unit ScriptClasses_C;

{
  Inno Setup
  Copyright (C) 1997-2007 Jordan Russell
  Portions by Martijn Laan
  For conditions of distribution and use, see LICENSE.TXT.

  Script support classes (compile time)

  $Id: ScriptClasses_C.pas,v 1.51 2007/07/19 18:09:39 jr Exp $
}

interface

uses
  uPSCompiler;

procedure ScriptClassesLibraryRegister_C(Cl: TPSPascalCompiler);

implementation

uses
  SetupTypes,
  uPSC_std, uPSC_classes, uPSC_graphics, uPSC_controls, uPSC_stdctrls,
  uPSC_forms, uPSC_extctrls, uPSC_comobj;

procedure RegisterNewStaticText_C(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(Cl.FindClass('TWINCONTROL'), 'TNEWSTATICTEXT') do
  begin
    RegisterProperty('AUTOSIZE', 'BOOLEAN', iptrw);
    RegisterProperty('CAPTION', 'String', iptrw);
    RegisterProperty('COLOR', 'TColor', iptrw);
    RegisterProperty('FOCUSCONTROL', 'TWinControl', iptrw);
    RegisterProperty('FONT', 'TFont', iptrw);
    RegisterProperty('ParentColor', 'Boolean', iptrw);
    RegisterProperty('ParentFont', 'Boolean', iptrw);
    RegisterProperty('SHOWACCELCHAR', 'Boolean', iptrw);
    RegisterProperty('WORDWRAP', 'Boolean', iptrw);
    RegisterProperty('ONCLICK', 'TNotifyEvent', iptrw);
    RegisterProperty('ONDBLCLICK', 'TNotifyEvent', iptrw);

    {$IFNDEF PS_MINIVCL}
    RegisterProperty('DRAGCURSOR', 'Longint', iptrw);
    RegisterProperty('DRAGMODE', 'TDragMode', iptrw);
    RegisterProperty('PARENTSHOWHINT', 'Boolean', iptrw);
    RegisterProperty('POPUPMENU', 'TPopupMenu', iptrw);
    RegisterProperty('ONDRAGDROP', 'TDragDropEvent', iptrw);
    RegisterProperty('ONDRAGOVER', 'TDragOverEvent', iptrw);
    RegisterProperty('ONENDDRAG', 'TEndDragEvent', iptrw);
    RegisterProperty('ONMOUSEDOWN', 'TMouseEvent', iptrw);
    RegisterProperty('ONMOUSEMOVE', 'TMouseMoveEvent', iptrw);
    RegisterProperty('ONMOUSEUP', 'TMouseEvent', iptrw);
    RegisterProperty('ONSTARTDRAG', 'TStartDragEvent', iptrw);
    {$ENDIF}
  end;
end;

procedure RegisterNewCheckListBox_C(Cl: TPSPascalCompiler);
begin
  Cl.AddTypeS('TCheckItemOperation', '(coUncheck, coCheck, coCheckWithChildren)');
  with Cl.AddClassN(Cl.FindClass('TCUSTOMLISTBOX'), 'TNEWCHECKLISTBOX') do
  begin
    RegisterMethod('function AddCheckBox(const ACaption, ASubItem: string; ALevel: Byte; AChecked, AEnabled, AHasInternalChildren, ACheckWhenParentChecked: Boolean; AObject: TObject): Integer');
    RegisterMethod('function AddGroup(const ACaption, ASubItem: string; ALevel: Byte; AObject: TObject): Integer');
    RegisterMethod('function AddRadioButton(const ACaption, ASubItem: string; ALevel: Byte; AChecked, AEnabled: Boolean; AObject: TObject): Integer');
    RegisterMethod('function CheckItem(const Index: Integer; const AOperation: TCheckItemOperation): Boolean');
    RegisterProperty('CHECKED', 'BOOLEAN INTEGER', iptrw);
    RegisterProperty('STATE', 'TCHECKBOXSTATE INTEGER', iptr);
    RegisterProperty('ITEMCAPTION', 'STRING INTEGER', iptrw);
    RegisterProperty('ITEMENABLED', 'BOOLEAN INTEGER', iptrw);
    RegisterProperty('ITEMLEVEL', 'BYTE INTEGER', iptr);
    RegisterProperty('ITEMOBJECT', 'TOBJECT INTEGER', iptrw);
    RegisterProperty('ITEMSUBITEM', 'STRING INTEGER', iptrw);
    RegisterProperty('FLAT', 'BOOLEAN', iptrw);
    RegisterProperty('MINITEMHEIGHT', 'INTEGER', iptrw);
    RegisterProperty('OFFSET', 'INTEGER', iptrw);
    RegisterProperty('ONCLICKCHECK', 'TNOTIFYEVENT', iptrw);
    RegisterProperty('BORDERSTYLE', 'TBORDERSTYLE', iptrw);
    RegisterProperty('COLOR', 'TColor', iptrw);
    RegisterProperty('FONT', 'TFont', iptrw);
    RegisterProperty('ParentColor', 'Boolean', iptrw);
    RegisterProperty('ParentFont', 'Boolean', iptrw);
    RegisterProperty('ONCLICK', 'TNotifyEvent', iptrw);
    RegisterProperty('ONDBLCLICK', 'TNotifyEvent', iptrw);
    RegisterProperty('ONKEYDOWN', 'TKeyEvent', iptrw);
    RegisterProperty('ONKEYPRESS', 'TKeyPressEvent', iptrw);
    RegisterProperty('ONKEYUP', 'TKeyEvent', iptrw);
    RegisterProperty('SHOWLINES', 'BOOLEAN', iptrw);
    RegisterProperty('WANTTABS', 'BOOLEAN', iptrw);
    RegisterProperty('ONENTER', 'TNotifyEvent', iptrw);
    RegisterProperty('ONEXIT', 'TNotifyEvent', iptrw);

    {$IFNDEF PS_MINIVCL}
    RegisterProperty('CTL3D', 'Boolean', iptrw);
    RegisterProperty('DRAGCURSOR', 'Longint', iptrw);
    RegisterProperty('DRAGMODE', 'TDragMode', iptrw);
    RegisterProperty('PARENTCTL3D', 'Boolean', iptrw);
    RegisterProperty('PARENTSHOWHINT', 'Boolean', iptrw);
    RegisterProperty('POPUPMENU', 'TPopupMenu', iptrw);
    RegisterProperty('ONDRAGDROP', 'TDragDropEvent', iptrw);
    RegisterProperty('ONDRAGOVER', 'TDragOverEvent', iptrw);
    RegisterProperty('ONENDDRAG', 'TEndDragEvent', iptrw);
    RegisterProperty('ONMOUSEDOWN', 'TMouseEvent', iptrw);
    RegisterProperty('ONMOUSEMOVE', 'TMouseMoveEvent', iptrw);
    RegisterProperty('ONMOUSEUP', 'TMouseEvent', iptrw);
    RegisterProperty('ONSTARTDRAG', 'TStartDragEvent', iptrw);
    {$ENDIF}
  end;
end;

procedure RegisterNewProgressBar_C(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(Cl.FindClass('TWINCONTROL'), 'TNEWPROGRESSBAR') do
  begin
    RegisterProperty('MIN', 'LONGINT', iptrw);
    RegisterProperty('MAX', 'LONGINT', iptrw);
    RegisterProperty('POSITION', 'LONGINT', iptrw);
  end;
end;

procedure RegisterRichEditViewer_C(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(Cl.FindClass('TMEMO'), 'TRICHEDITVIEWER') do
  begin
    RegisterProperty('RTFTEXT', 'STRING', iptw);
    RegisterProperty('USERICHEDIT', 'BOOLEAN', iptrw);
  end;
end;

procedure RegisterPasswordEdit_C(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(cl.FindClass('TCUSTOMEDIT'), 'TPASSWORDEDIT') do
  begin
    RegisterProperty('AUTOSELECT', 'Boolean', iptrw);
    RegisterProperty('AUTOSIZE', 'Boolean', iptrw);
    RegisterProperty('BORDERSTYLE', 'TBorderStyle', iptrw);
    RegisterProperty('COLOR', 'TColor', iptrw);
    RegisterProperty('FONT', 'TFont', iptrw);
    RegisterProperty('HIDESELECTION', 'Boolean', iptrw);
    RegisterProperty('MAXLENGTH', 'Integer', iptrw);
    RegisterProperty('ParentColor', 'Boolean', iptrw);
    RegisterProperty('ParentFont', 'Boolean', iptrw);
    RegisterProperty('Password', 'Boolean', iptrw);
    RegisterProperty('READONLY', 'Boolean', iptrw);
    RegisterProperty('TEXT', 'string', iptrw);
    RegisterProperty('ONCHANGE', 'TNotifyEvent', iptrw);
    RegisterProperty('ONCLICK', 'TNotifyEvent', iptrw);
    RegisterProperty('ONDBLCLICK', 'TNotifyEvent', iptrw);
    RegisterProperty('ONKEYDOWN', 'TKeyEvent', iptrw);
    RegisterProperty('ONKEYPRESS', 'TKeyPressEvent', iptrw);
    RegisterProperty('ONKEYUP', 'TKeyEvent', iptrw);
    RegisterProperty('ONENTER', 'TNotifyEvent', iptrw);
    RegisterProperty('ONEXIT', 'TNotifyEvent', iptrw);

    {$IFNDEF PS_MINIVCL}
    RegisterProperty('CHARCASE', 'TEditCharCase', iptrw);
    RegisterProperty('CTL3D', 'Boolean', iptrw);
    RegisterProperty('DRAGCURSOR', 'Longint', iptrw);
    RegisterProperty('DRAGMODE', 'TDragMode', iptrw);
    RegisterProperty('OEMCONVERT', 'Boolean', iptrw);
    RegisterProperty('PARENTCTL3D', 'Boolean', iptrw);
    RegisterProperty('PARENTSHOWHINT', 'Boolean', iptrw);
    RegisterProperty('POPUPMENU', 'TPopupMenu', iptrw);
    RegisterProperty('ONDRAGDROP', 'TDragDropEvent', iptrw);
    RegisterProperty('ONDRAGOVER', 'TDragOverEvent', iptrw);
    RegisterProperty('ONENDDRAG', 'TEndDragEvent', iptrw);
    RegisterProperty('ONMOUSEDOWN', 'TMouseEvent', iptrw);
    RegisterProperty('ONMOUSEMOVE', 'TMouseMoveEvent', iptrw);
    RegisterProperty('ONMOUSEUP', 'TMouseEvent', iptrw);
    RegisterProperty('ONSTARTDRAG', 'TStartDragEvent', iptrw);
    {$ENDIF}
  end;
end;

procedure RegisterCustomFolderTreeView_C(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(Cl.FindClass('TWinControl'),'TCustomFolderTreeView') do
  begin
    RegisterMethod('Procedure ChangeDirectory( const Value : String; const CreateNewItems : Boolean)');
    RegisterMethod('Procedure CreateNewDirectory( const ADefaultName : String)');
    RegisterProperty('Directory', 'String', iptrw);
  end;
  CL.AddTypeS('TFolderRenameEvent', 'Procedure ( Sender : TCustomFolderTreeView; var NewName : String; var Accept : Boolean)');
end;

procedure RegisterFolderTreeView_C(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(Cl.FindClass('TCustomFolderTreeView'),'TFolderTreeView') do
  begin
    RegisterProperty('OnChange', 'TNotifyEvent', iptrw);
    RegisterProperty('OnRename', 'TFolderRenameEvent', iptrw);
  end;
end;

procedure RegisterStartMenuFolderTreeView_C(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(Cl.FindClass('TCustomFolderTreeView'),'TStartMenuFolderTreeView') do
  begin
    RegisterMethod('Procedure SetPaths( const AUserPrograms, ACommonPrograms, AUserStartup, ACommonStartup : String)');
    RegisterProperty('OnChange', 'TNotifyEvent', iptrw);
    RegisterProperty('OnRename', 'TFolderRenameEvent', iptrw);
  end;
end;

procedure RegisterBitmapImage_C(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(CL.FindClass('TGraphicControl'),'TBitmapImage') do
  begin
    RegisterProperty('AutoSize', 'Boolean', iptrw);
    RegisterProperty('BackColor', 'TColor', iptrw);
    RegisterProperty('Center', 'Boolean', iptrw);
    RegisterProperty('Bitmap', 'TBitmap', iptrw);
    RegisterProperty('ReplaceColor', 'TColor', iptrw);
    RegisterProperty('ReplaceWithColor', 'TColor', iptrw);
    RegisterProperty('Stretch', 'Boolean', iptrw);
  end;
end;

procedure RegisterNewNotebook_C(Cl: TPSPascalCompiler);
begin
  Cl.AddClassN(Cl.FindClass('TCustomControl'),'TNewNotebookPage');

  with Cl.AddClassN(Cl.FindClass('TWinControl'),'TNewNotebook') do
  begin
    RegisterMethod('Function FindNextPage( CurPage : TNewNotebookPage; GoForward : Boolean) : TNewNotebookPage');
    RegisterProperty('PageCount', 'Integer', iptr);
    RegisterProperty('Pages', 'TNewNotebookPage Integer', iptr);
    RegisterProperty('ActivePage', 'TNewNotebookPage', iptrw);
  end;
end;

procedure RegisterNewNotebookPage_C(Cl: TPSPascalCompiler);
begin
  with Cl.FindClass('TNewNotebookPage') do
  begin
    RegisterProperty('Color', 'TColor', iptrw);
    RegisterProperty('Notebook', 'TNewNotebook', iptrw);
    RegisterProperty('PageIndex', 'Integer', iptrw);
  end;
end;

procedure RegisterUIStateForm_C(Cl: TPSPascalCompiler);
begin
  Cl.AddClassN(Cl.FindClass('TForm'), 'TUIStateForm');
end;

procedure RegisterSetupForm_C(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(Cl.FindClass('TUIStateForm'), 'TSetupForm') do
  begin
    RegisterMethod('procedure Center');
    RegisterMethod('procedure CenterInsideControl(const Ctl: TWinControl; const InsideClientArea: Boolean)');
  end;
end;

procedure RegisterMainForm_C(Cl: TPSPascalCompiler);
begin
  with CL.AddClassN(CL.FindClass('TSetupForm'), 'TMainForm') do
  begin
    RegisterMethod('Procedure ShowAboutBox');
  end;
end;

procedure RegisterWizardForm_C(Cl: TPSPascalCompiler);
begin
  with Cl.AddClassN(Cl.FindClass('TSetupForm'), 'TWizardForm') do
  begin
    RegisterProperty('CANCELBUTTON', 'TBUTTON', iptr);
    RegisterProperty('NEXTBUTTON', 'TBUTTON', iptr);
    RegisterProperty('BACKBUTTON', 'TBUTTON', iptr);
    RegisterProperty('OuterNotebook', 'TNewNotebook', iptr);
    RegisterProperty('InnerNotebook', 'TNewNotebook', iptr);
    RegisterProperty('WelcomePage', 'TNewNotebookPage', iptr);
    RegisterProperty('InnerPage', 'TNewNotebookPage', iptr);
    RegisterProperty('FinishedPage', 'TNewNotebookPage', iptr);
    RegisterProperty('LicensePage', 'TNewNotebookPage', iptr);
    RegisterProperty('PasswordPage', 'TNewNotebookPage', iptr);
    RegisterProperty('InfoBeforePage', 'TNewNotebookPage', iptr);
    RegisterProperty('UserInfoPage', 'TNewNotebookPage', iptr);
    RegisterProperty('SelectDirPage', 'TNewNotebookPage', iptr);
    RegisterProperty('SelectComponentsPage', 'TNewNotebookPage', iptr);
    RegisterProperty('SelectProgramGroupPage', 'TNewNotebookPage', iptr);
    RegisterProperty('SelectTasksPage', 'TNewNotebookPage', iptr);
    RegisterProperty('ReadyPage', 'TNewNotebookPage', iptr);
    RegisterProperty('PreparingPage', 'TNewNotebookPage', iptr);
    RegisterProperty('InstallingPage', 'TNewNotebookPage', iptr);
    RegisterProperty('InfoAfterPage', 'TNewNotebookPage', iptr);
    RegisterProperty('DISKSPACELABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('DIREDIT', 'TEDIT', iptr);
    RegisterProperty('GROUPEDIT', 'TEDIT', iptr);
    RegisterProperty('NOICONSCHECK', 'TCHECKBOX', iptr);
    RegisterProperty('PASSWORDLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('PASSWORDEDIT', 'TPASSWORDEDIT', iptr);
    RegisterProperty('PASSWORDEDITLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('READYMEMO', 'TMEMO', iptr);
    RegisterProperty('TYPESCOMBO', 'TCOMBOBOX', iptr);
    RegisterProperty('BEVEL', 'TBEVEL', iptr);
    RegisterProperty('WizardBitmapImage', 'TBitmapImage', iptr);
    RegisterProperty('WELCOMELABEL1', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('INFOBEFOREMEMO', 'TRICHEDITVIEWER', iptr);
    RegisterProperty('INFOBEFORECLICKLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('MAINPANEL', 'TPANEL', iptr);
    RegisterProperty('BEVEL1', 'TBEVEL', iptr);
    RegisterProperty('PAGENAMELABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('PAGEDESCRIPTIONLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('WizardSmallBitmapImage', 'TBitmapImage', iptr);
    RegisterProperty('READYLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('FINISHEDLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('YESRADIO', 'TRADIOBUTTON', iptr);
    RegisterProperty('NORADIO', 'TRADIOBUTTON', iptr);
    RegisterProperty('WizardBitmapImage2', 'TBitmapImage', iptr);
    RegisterProperty('WELCOMELABEL2', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('LICENSELABEL1', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('LICENSEMEMO', 'TRICHEDITVIEWER', iptr);
    RegisterProperty('INFOAFTERMEMO', 'TRICHEDITVIEWER', iptr);
    RegisterProperty('INFOAFTERCLICKLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('COMPONENTSLIST', 'TNEWCHECKLISTBOX', iptr);
    RegisterProperty('COMPONENTSDISKSPACELABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('BEVELEDLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('STATUSLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('FILENAMELABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('PROGRESSGAUGE', 'TNEWPROGRESSBAR', iptr);
    RegisterProperty('SELECTDIRLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('SELECTSTARTMENUFOLDERLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('SELECTCOMPONENTSLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('SELECTTASKSLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('LICENSEACCEPTEDRADIO', 'TRADIOBUTTON', iptr);
    RegisterProperty('LICENSENOTACCEPTEDRADIO', 'TRADIOBUTTON', iptr);
    RegisterProperty('USERINFONAMELABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('USERINFONAMEEDIT', 'TEDIT', iptr);
    RegisterProperty('USERINFOORGLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('USERINFOORGEDIT', 'TEDIT', iptr);
    RegisterProperty('PreparingErrorBitmapImage', 'TBitmapImage', iptr);
    RegisterProperty('PREPARINGLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('FINISHEDHEADINGLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('USERINFOSERIALLABEL', 'TNEWSTATICTEXT', iptr);
    RegisterProperty('USERINFOSERIALEDIT', 'TEDIT', iptr);
    RegisterProperty('TASKSLIST', 'TNEWCHECKLISTBOX', iptr);
    RegisterProperty('RUNLIST', 'TNEWCHECKLISTBOX', iptr);
    RegisterProperty('DirBrowseButton', 'TButton', iptr);
    RegisterProperty('GroupBrowseButton', 'TButton', iptr);
    RegisterProperty('SelectDirBitmapImage', 'TBitmapImage', iptr);
    RegisterProperty('SelectGroupBitmapImage', 'TBitmapImage', iptr);
    RegisterProperty('SelectDirBrowseLabel', 'TNewStaticText', iptr);
    RegisterProperty('SelectStartMenuFolderBrowseLabel', 'TNewStaticText', iptr);
    RegisterProperty('CurPageID', 'Integer', iptr);
    RegisterMethod('function ADJUSTLABELHEIGHT(ALABEL:TNEWSTATICTEXT):INTEGER');
    RegisterMethod('procedure INCTOPDECHEIGHT(ACONTROL:TCONTROL;AMOUNT:INTEGER)');
  end;
end;

procedure RegisterWizardPage_C(Cl: TIFPSPascalCompiler);
var
  NewClass: TPSCompileTimeClass;
begin
  NewClass := Cl.AddClassN(Cl.FindClass('TComponent'), 'TWizardPage');
  CL.AddTypeS('TWizardPageNotifyEvent', 'procedure(Sender: TWizardPage)');
  CL.AddTypeS('TWizardPageButtonEvent', 'function(Sender: TWizardPage): Boolean');
  CL.AddTypeS('TWizardPageCancelEvent', 'procedure(Sender: TWizardPage; var ACancel, AConfirm: Boolean)');
  CL.AddTypeS('TWizardPageShouldSkipEvent', 'function(Sender: TWizardPage): Boolean');
  with NewClass do
  begin
    RegisterProperty('ID', 'Integer', iptr);
    RegisterProperty('Caption', 'String', iptrw);
    RegisterProperty('Description', 'String', iptrw);
    RegisterProperty('Surface', 'TNewNotebookPage', iptr);
    RegisterProperty('SurfaceHeight', 'Integer', iptr);
    RegisterProperty('SurfaceWidth', 'Integer', iptr);
    RegisterProperty('OnActivate', 'TWizardPageNotifyEvent', iptrw);
    RegisterProperty('OnBackButtonClick', 'TWizardPageButtonEvent', iptrw);
    RegisterProperty('OnCancelButtonClick', 'TWizardPageCancelEvent', iptrw);
    RegisterProperty('OnNextButtonClick', 'TWizardPageButtonEvent', iptrw);
    RegisterProperty('OnShouldSkipPage', 'TWizardPageShouldSkipEvent', iptrw);
  end;
end;

procedure RegisterInputQueryWizardPage_C(Cl: TPSPascalCompiler);
begin
  with CL.AddClassN(Cl.FindClass('TWizardPage'),'TInputQueryWizardPage') do
  begin
    RegisterMethod('function Add(const APrompt: String; const APassword: Boolean): Integer');
    RegisterProperty('Edits', 'TPasswordEdit Integer', iptr);
    RegisterProperty('PromptLabels', 'TNewStaticText Integer', iptr);
    RegisterProperty('SubCaptionLabel', 'TNewStaticText', iptr);
    RegisterProperty('Values', 'String Integer', iptrw);
  end;
end;

procedure RegisterInputOptionWizardPage_C(Cl: TPSPascalCompiler);
begin
  with CL.AddClassN(Cl.FindClass('TWizardPage'),'TInputOptionWizardPage') do
  begin
    RegisterMethod('function Add(const ACaption: String): Integer');
    RegisterMethod('function AddEx(const ACaption: String; const ALevel: Byte; const AExclusive: Boolean): Integer');
    RegisterProperty('CheckListBox', 'TNewCheckListBox', iptr);
    RegisterProperty('SelectedValueIndex', 'Integer', iptrw);
    RegisterProperty('SubCaptionLabel', 'TNewStaticText', iptr);
    RegisterProperty('Values', 'Boolean Integer', iptrw);
  end;
end;

procedure RegisterInputDirWizardPage_C(CL: TPSPascalCompiler);
begin
  with CL.AddClassN(CL.FindClass('TWizardPage'),'TInputDirWizardPage') do
  begin
    RegisterMethod('function Add(const APrompt: String): Integer');
    RegisterProperty('Buttons', 'TButton Integer', iptr);
    RegisterProperty('Edits', 'TEdit Integer', iptr);
    RegisterProperty('PromptLabels', 'TNewStaticText Integer', iptr);
    RegisterProperty('SubCaptionLabel', 'TNewStaticText', iptr);
    RegisterProperty('Values', 'String Integer', iptrw);
  end;
end;

procedure RegisterInputFileWizardPage_C(Cl: TPSPascalCompiler);
begin
  with CL.AddClassN(Cl.FindClass('TWizardPage'),'TInputFileWizardPage') do
  begin
    RegisterMethod('function Add(const APrompt, AFilter, ADefaultExtension: String): Integer');
    RegisterProperty('Buttons', 'TButton Integer', iptr);
    RegisterProperty('Edits', 'TEdit Integer', iptr);
    RegisterProperty('PromptLabels', 'TNewStaticText Integer', iptr);
    RegisterProperty('SubCaptionLabel', 'TNewStaticText', iptr);
    RegisterProperty('Values', 'String Integer', iptrw);
    RegisterProperty('IsSaveButton', 'Boolean Integer', iptrw);
  end;
end;

procedure RegisterOutputMsgWizardPage_C(Cl: TPSPascalCompiler);
begin
  with CL.AddClassN(Cl.FindClass('TWizardPage'),'TOutputMsgWizardPage') do
  begin
    RegisterProperty('MsgLabel', 'TNewStaticText', iptr);
  end;
end;

procedure RegisterOutputMsgMemoWizardPage_C(Cl: TPSPascalCompiler);
begin
  with CL.AddClassN(Cl.FindClass('TWizardPage'),'TOutputMsgMemoWizardPage') do
  begin
    RegisterProperty('RichEditViewer', 'TRichEditViewer', iptr);
    RegisterProperty('SubCaptionLabel', 'TNewStaticText', iptr);
  end;
end;

procedure RegisterOutputProgressWizardPage_C(Cl: TPSPascalCompiler);
begin
  with CL.AddClassN(Cl.FindClass('TWizardPage'),'TOutputProgressWizardPage') do
  begin
    RegisterMethod('procedure Hide');
    RegisterProperty('Msg1Label', 'TNewStaticText', iptr);
    RegisterProperty('Msg2Label', 'TNewStaticText', iptr);
    RegisterProperty('ProgressBar', 'TNewProgressBar', iptr);
    RegisterMethod('procedure SetProgress(const Position, Max: Longint)');
    RegisterMethod('procedure SetText(const Msg1, Msg2: String)');
    RegisterMethod('procedure Show');
  end;
end;

procedure RegisterHandCursor_C(Cl: TPSPascalCompiler);
begin
  cl.AddConstantN('crHand', 'Integer').Value.ts32 := crHand;
end;

procedure ScriptClassesLibraryRegister_C(Cl: TPSPascalCompiler);
begin
  { Std }
  SIRegister_Std_TypesAndConsts(Cl);
  SIRegisterTObject(Cl);
  SIRegisterTPersistent(Cl);
  SIRegisterTComponent(Cl);

  { Classes }
  SIRegister_Classes_TypesAndConsts(Cl);
  SIRegisterTStream(Cl);
  SIRegisterTStrings(Cl, True);
  SIRegisterTStringList(Cl);
  SIRegisterTHandleStream(Cl);
  SIRegisterTFileStream(Cl);

  { Graphics }
  SIRegister_Graphics_TypesAndConsts(Cl);
  SIRegisterTGraphicsObject(Cl);
  SIRegisterTFont(Cl);
  SIRegisterTPen(Cl);
  SIRegisterTBrush(Cl);
  SIRegisterTCanvas(Cl);
  SIRegisterTGraphic(Cl);
  SIRegisterTBitmap(Cl, True);

  { Controls }
  SIRegister_Controls_TypesAndConsts(Cl);
  SIRegisterTDragObject(Cl);
  SIRegisterTControl(Cl);
  SIRegisterTWinControl(Cl);
  SIRegisterTGraphicControl(Cl);
  SIRegisterTCustomControl(Cl);

  { Forms }
  SIRegister_Forms_TypesAndConsts(Cl);
  SIRegisterTScrollingWinControl(Cl);
  SIRegisterTForm(Cl);

  { StdCtrls }
  SIRegister_StdCtrls_TypesAndConsts(Cl);
  SIRegisterTCustomLabel(Cl);
  SIRegisterTLabel(Cl);
  SIRegisterTCustomEdit(Cl);
  SIRegisterTEdit(Cl);
  SIRegisterTCustomMemo(Cl);
  SIRegisterTMemo(Cl);
  SIRegisterTCustomComboBox(Cl);
  SIRegisterTComboBox(Cl);
  SIRegisterTButtonControl(Cl);
  SIRegisterTButton(Cl);
  SIRegisterTCustomCheckBox(Cl);
  SIRegisterTCheckBox(Cl);
  SIRegisterTRadioButton(Cl);
  SIRegisterTCustomListBox(Cl);
  SIRegisterTListBox(Cl);

  { ExtCtrls }
  SIRegister_ExtCtrls_TypesAndConsts(cl);
  SIRegisterTBevel(Cl);
  SIRegisterTCustomPanel(Cl);
  SIRegisterTPanel(Cl);

  { ComObj }
  SIRegister_ComObj(Cl);

  RegisterNewStaticText_C(Cl);
  RegisterNewCheckListBox_C(Cl);
  RegisterNewProgressBar_C(Cl);
  RegisterRichEditViewer_C(Cl);
  RegisterPasswordEdit_C(Cl);
  RegisterCustomFolderTreeView_C(Cl);
  RegisterFolderTreeView_C(Cl);
  RegisterStartMenuFolderTreeView_C(Cl);
  RegisterBitmapImage_C(Cl);

  RegisterNewNotebook_C(Cl);
  RegisterNewNotebookPage_C(Cl);

  RegisterUIStateForm_C(Cl);
  RegisterSetupForm_C(Cl);
  RegisterMainForm_C(Cl);
  RegisterWizardForm_C(Cl);

  RegisterWizardPage_C(Cl);
  RegisterInputQueryWizardPage_C(Cl);
  RegisterInputOptionWizardPage_C(Cl);
  RegisterInputDirWizardPage_C(Cl);
  RegisterInputFileWizardPage_C(Cl);
  RegisterOutputMsgWizardPage_C(Cl);
  RegisterOutputMsgMemoWizardPage_C(Cl);
  RegisterOutputProgressWizardPage_C(Cl);

  RegisterHandCursor_C(Cl);
end;

end.
