unit ScriptClasses_R;

{
  Inno Setup
  Copyright (C) 1997-2007 Jordan Russell
  Portions by Martijn Laan
  For conditions of distribution and use, see LICENSE.TXT.

  Script support classes (run time)

  $Id: ScriptClasses_R.pas,v 1.47 2007/07/19 18:09:39 jr Exp $
}

interface

uses
  uPSRuntime;

function ScriptClassesLibraryRegister_R(ScriptInterpreter: TPSExec): TPSRuntimeClassImporter;

implementation

uses
  Windows, Controls, Forms, StdCtrls, Graphics,
  uPSR_std, uPSR_classes, uPSR_graphics, uPSR_controls, uPSR_forms,
  uPSR_stdctrls, uPSR_extctrls, uPSR_comobj,
  NewStaticText, NewCheckListBox, NewProgressBar, RichEditViewer,
  ExtCtrls, UIStateForm, SetupForm, Main, Wizard, SetupTypes, PasswordEdit,
  FolderTreeView, BitmapImage, NewNotebook, ScriptDlg;

procedure RegisterNewStaticText_R(Cl: TPSRuntimeClassImporter);
begin
  Cl.Add(TNewStaticText);
end;

procedure TNEWCHECKLISTBOXCHECKED_R(Self: TNEWCHECKLISTBOX; var T: BOOLEAN; t1: INTEGER); begin T := Self.CHECKED[t1]; end;
procedure TNEWCHECKLISTBOXCHECKED_W(Self: TNEWCHECKLISTBOX; const T: BOOLEAN; t1: INTEGER); begin Self.CHECKED[t1] := T; end;
procedure TNEWCHECKLISTBOXSTATE_R(Self: TNEWCHECKLISTBOX; var T: TCHECKBOXSTATE; t1: INTEGER); begin T := Self.STATE[t1]; end;
procedure TNEWCHECKLISTBOXITEMCAPTION_R(Self: TNEWCHECKLISTBOX; var T: STRING; t1: INTEGER); begin T := Self.ITEMCAPTION[t1]; end;
procedure TNEWCHECKLISTBOXITEMCAPTION_W(Self: TNEWCHECKLISTBOX; const T: STRING; t1: INTEGER); begin Self.ITEMCAPTION[t1] := T; end;
procedure TNEWCHECKLISTBOXITEMENABLED_R(Self: TNEWCHECKLISTBOX; var T: BOOLEAN; t1: INTEGER); begin T := Self.ITEMENABLED[t1]; end;
procedure TNEWCHECKLISTBOXITEMENABLED_W(Self: TNEWCHECKLISTBOX; const T: BOOLEAN; t1: INTEGER); begin Self.ITEMENABLED[t1] := T; end;
procedure TNEWCHECKLISTBOXITEMLEVEL_R(Self: TNEWCHECKLISTBOX; var T: BYTE; t1: INTEGER); begin T := Self.ITEMLEVEL[t1]; end;
procedure TNEWCHECKLISTBOXITEMOBJECT_R(Self: TNEWCHECKLISTBOX; var T: TOBJECT; t1: INTEGER); begin T := Self.ITEMOBJECT[t1]; end;
procedure TNEWCHECKLISTBOXITEMOBJECT_W(Self: TNEWCHECKLISTBOX; const T: TOBJECT; t1: INTEGER); begin Self.ITEMOBJECT[t1] := T; end;
procedure TNEWCHECKLISTBOXITEMSUBITEM_R(Self: TNEWCHECKLISTBOX; var T: STRING; t1: INTEGER); begin T := Self.ITEMSUBITEM[t1]; end;
procedure TNEWCHECKLISTBOXITEMSUBITEM_W(Self: TNEWCHECKLISTBOX; const T: STRING; t1: INTEGER); begin Self.ITEMSUBITEM[t1] := T; end;

procedure RegisterNewCheckListBox_R(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TNewCheckListBox) do
  begin
    RegisterMethod(@TNEWCHECKLISTBOX.ADDCHECKBOX, 'ADDCHECKBOX');
    RegisterMethod(@TNEWCHECKLISTBOX.ADDGROUP, 'ADDGROUP');
    RegisterMethod(@TNEWCHECKLISTBOX.ADDRADIOBUTTON, 'ADDRADIOBUTTON');
    RegisterMethod(@TNewCheckListBox.CheckItem, 'CheckItem');
    RegisterPropertyHelper(@TNEWCHECKLISTBOXCHECKED_R, @TNEWCHECKLISTBOXCHECKED_W, 'CHECKED');
    RegisterPropertyHelper(@TNEWCHECKLISTBOXSTATE_R, nil, 'STATE');
    RegisterPropertyHelper(@TNEWCHECKLISTBOXITEMCAPTION_R, @TNEWCHECKLISTBOXITEMCAPTION_W, 'ITEMCAPTION');
    RegisterPropertyHelper(@TNEWCHECKLISTBOXITEMENABLED_R, @TNEWCHECKLISTBOXITEMENABLED_W, 'ITEMENABLED');
    RegisterPropertyHelper(@TNEWCHECKLISTBOXITEMLEVEL_R, nil, 'ITEMLEVEL');
    RegisterPropertyHelper(@TNEWCHECKLISTBOXITEMOBJECT_R, @TNEWCHECKLISTBOXITEMOBJECT_W, 'ITEMOBJECT');
    RegisterPropertyHelper(@TNEWCHECKLISTBOXITEMSUBITEM_R, @TNEWCHECKLISTBOXITEMSUBITEM_W, 'ITEMSUBITEM');
  end;
end;

procedure RegisterNewProgressBar_R(Cl: TPSRuntimeClassImporter);
begin
  Cl.Add(TNEWPROGRESSBAR);
end;

procedure TRICHEDITVIEWERRTFTEXT_W(Self: TRICHEDITVIEWER; const T: STRING); begin Self.RTFTEXT := T; end;

procedure RegisterRichEditViewer_R(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TRichEditViewer) do
  begin
    RegisterPropertyHelper(nil, @TRICHEDITVIEWERRTFTEXT_W, 'RTFTEXT');
  end;
end;

procedure TPasswordEditPassword_W(Self: TPasswordEdit; const T: Boolean); begin Self.Password := T; end;
procedure TPasswordEditPassword_R(Self: TPasswordEdit; var T: Boolean); begin T := Self.Password; end;

procedure RegisterPasswordEdit_R(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TPasswordEdit) do
  begin
    RegisterPropertyHelper(@TPasswordEditPassword_R, @TPasswordEditPassword_W, 'Password');
  end;
end;

procedure TCustomFolderTreeViewDirectory_W(Self: TCustomFolderTreeView; const T: String); begin Self.Directory := T; end;
procedure TCustomFolderTreeViewDirectory_R(Self: TCustomFolderTreeView; var T: String); begin T := Self.Directory; end;

procedure RegisterCustomFolderTreeView_R(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TCustomFolderTreeView) do
  begin
    RegisterMethod(@TCustomFolderTreeView.ChangeDirectory, 'ChangeDirectory');
    RegisterMethod(@TCustomFolderTreeView.CreateNewDirectory, 'CreateNewDirectory');
    RegisterPropertyHelper(@TCustomFolderTreeViewDirectory_R,@TCustomFolderTreeViewDirectory_W,'Directory');
  end;
end;

procedure RegisterStartMenuFolderTreeView_R(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TStartMenuFolderTreeView) do
  begin
    RegisterMethod(@TStartMenuFolderTreeView.SetPaths, 'SetPaths');
  end;
end;

procedure RegisterFolderTreeView_R(Cl: TPSRuntimeClassImporter);
begin
  Cl.Add(TFolderTreeView);
end;

procedure TBitmapImageStretch_W(Self: TBitmapImage; const T: Boolean); begin Self.Stretch := T; end;
procedure TBitmapImageStretch_R(Self: TBitmapImage; var T: Boolean); begin T := Self.Stretch; end;
procedure TBitmapImageReplaceWithColor_W(Self: TBitmapImage; const T: TColor); begin Self.ReplaceWithColor := T; end;
procedure TBitmapImageReplaceWithColor_R(Self: TBitmapImage; var T: TColor); begin T := Self.ReplaceWithColor; end;
procedure TBitmapImageReplaceColor_W(Self: TBitmapImage; const T: TColor); begin Self.ReplaceColor := T; end;
procedure TBitmapImageReplaceColor_R(Self: TBitmapImage; var T: TColor); begin T := Self.ReplaceColor; end;
procedure TBitmapImageBitmap_W(Self: TBitmapImage; const T: TBitmap); begin Self.Bitmap := T; end;
procedure TBitmapImageBitmap_R(Self: TBitmapImage; var T: TBitmap); begin T := Self.Bitmap; end;
procedure TBitmapImageCenter_W(Self: TBitmapImage; const T: Boolean); begin Self.Center := T; end;
procedure TBitmapImageCenter_R(Self: TBitmapImage; var T: Boolean); begin T := Self.Center; end;
procedure TBitmapImageBackColor_W(Self: TBitmapImage; const T: TColor); begin Self.BackColor := T; end;
procedure TBitmapImageBackColor_R(Self: TBitmapImage; var T: TColor); begin T := Self.BackColor; end;
procedure TBitmapImageAutoSize_W(Self: TBitmapImage; const T: Boolean); begin Self.AutoSize := T; end;
procedure TBitmapImageAutoSize_R(Self: TBitmapImage; var T: Boolean); begin T := Self.AutoSize; end;

procedure RegisterBitmapImage_R(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TBitmapImage) do
  begin
    RegisterPropertyHelper(@TBitmapImageAutoSize_R,@TBitmapImageAutoSize_W,'AutoSize');
    RegisterPropertyHelper(@TBitmapImageBackColor_R,@TBitmapImageBackColor_W,'BackColor');
    RegisterPropertyHelper(@TBitmapImageCenter_R,@TBitmapImageCenter_W,'Center');
    RegisterPropertyHelper(@TBitmapImageBitmap_R,@TBitmapImageBitmap_W,'Bitmap');
    RegisterPropertyHelper(@TBitmapImageReplaceColor_R,@TBitmapImageReplaceColor_W,'ReplaceColor');
    RegisterPropertyHelper(@TBitmapImageReplaceWithColor_R,@TBitmapImageReplaceWithColor_W,'ReplaceWithColor');
    RegisterPropertyHelper(@TBitmapImageStretch_R,@TBitmapImageStretch_W,'Stretch');
  end;
end;

procedure TNewNotebookActivePage_W(Self: TNewNotebook; const T: TNewNotebookPage); begin Self.ActivePage := T; end;
procedure TNewNotebookActivePage_R(Self: TNewNotebook; var T: TNewNotebookPage); begin T := Self.ActivePage; end;
procedure TNewNotebookPages_R(Self: TNewNotebook; var T: TNewNotebookPage; const t1: Integer); begin T := Self.Pages[t1]; end;
procedure TNewNotebookPageCount_R(Self: TNewNotebook; var T: Integer); begin T := Self.PageCount; end;

procedure RegisterNewNotebook_R(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TNewNotebook) do
  begin
    RegisterMethod(@TNewNotebook.FindNextPage, 'FindNextPage');
    RegisterPropertyHelper(@TNewNotebookPageCount_R,nil,'PageCount');
    RegisterPropertyHelper(@TNewNotebookPages_R,nil,'Pages');
    RegisterPropertyHelper(@TNewNotebookActivePage_R,@TNewNotebookActivePage_W,'ActivePage');
  end;
end;

procedure TNewNotebookPagePageIndex_W(Self: TNewNotebookPage; const T: Integer); begin Self.PageIndex := T; end;
procedure TNewNotebookPagePageIndex_R(Self: TNewNotebookPage; var T: Integer); begin T := Self.PageIndex; end;
procedure TNewNotebookPageNotebook_W(Self: TNewNotebookPage; const T: TNewNotebook); begin Self.Notebook := T; end;
procedure TNewNotebookPageNotebook_R(Self: TNewNotebookPage; var T: TNewNotebook); begin T := Self.Notebook; end;

procedure RegisterNewNotebookPage_R(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TNewNotebookPage) do
  begin
    RegisterPropertyHelper(@TNewNotebookPageNotebook_R,@TNewNotebookPageNotebook_W,'Notebook');
    RegisterPropertyHelper(@TNewNotebookPagePageIndex_R,@TNewNotebookPagePageIndex_W,'PageIndex');
  end;
end;

procedure RegisterUIStateForm_R(Cl: TPSRuntimeClassImporter);
begin
  Cl.Add(TUIStateForm);
end;

procedure RegisterSetupForm_R(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TSetupForm) do
  begin
    RegisterMethod(@TSetupForm.Center, 'Center');
    RegisterMethod(@TSetupForm.CenterInsideControl, 'CenterInsideControl');
  end;
end;

procedure RegisterMainForm_R(Cl: TPSRuntimeClassImporter);
begin
  with CL.Add(TMainForm) do
  begin
    RegisterMethod(@TMainForm.ShowAboutBox, 'ShowAboutBox');
  end;
end;

procedure TWIZARDFORMCANCELBUTTON_R(Self: TWIZARDFORM; var T: TBUTTON); begin T := Self.CANCELBUTTON; end;
procedure TWIZARDFORMNEXTBUTTON_R(Self: TWIZARDFORM; var T: TBUTTON); begin T := Self.NEXTBUTTON; end;
procedure TWIZARDFORMBACKBUTTON_R(Self: TWIZARDFORM; var T: TBUTTON); begin T := Self.BACKBUTTON; end;
procedure TWIZARDFORMOuterNotebook_R(Self: TWIZARDFORM; var T: TNewNotebook); begin T := Self.OuterNotebook; end;
procedure TWIZARDFORMInnerNotebook_R(Self: TWIZARDFORM; var T: TNewNotebook); begin T := Self.InnerNotebook; end;
procedure TWizardFormInfoAfterPage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.InfoAfterPage; end;
procedure TWizardFormInstallingPage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.InstallingPage; end;
procedure TWizardFormPreparingPage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.PreparingPage; end;
procedure TWizardFormReadyPage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.ReadyPage; end;
procedure TWizardFormSelectTasksPage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.SelectTasksPage; end;
procedure TWizardFormSelectProgramGroupPage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.SelectProgramGroupPage; end;
procedure TWizardFormSelectComponentsPage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.SelectComponentsPage; end;
procedure TWizardFormSelectDirPage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.SelectDirPage; end;
procedure TWizardFormUserInfoPage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.UserInfoPage; end;
procedure TWizardFormInfoBeforePage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.InfoBeforePage; end;
procedure TWizardFormPasswordPage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.PasswordPage; end;
procedure TWizardFormLicensePage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.LicensePage; end;
procedure TWizardFormFinishedPage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.FinishedPage; end;
procedure TWizardFormInnerPage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.InnerPage; end;
procedure TWizardFormWelcomePage_R(Self: TWizardForm; var T: TNewNotebookPage); Begin T := Self.WelcomePage; end;
procedure TWIZARDFORMDISKSPACELABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.DISKSPACELABEL; end;
procedure TWIZARDFORMDIREDIT_R(Self: TWIZARDFORM; var T: TEDIT); begin T := Self.DIREDIT; end;
procedure TWIZARDFORMGROUPEDIT_R(Self: TWIZARDFORM; var T: TEDIT); begin T := Self.GROUPEDIT; end;
procedure TWIZARDFORMNOICONSCHECK_R(Self: TWIZARDFORM; var T: TCHECKBOX); begin T := Self.NOICONSCHECK; end;
procedure TWIZARDFORMPASSWORDLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.PASSWORDLABEL; end;
procedure TWIZARDFORMPASSWORDEDIT_R(Self: TWIZARDFORM; var T: TPASSWORDEDIT); begin T := Self.PASSWORDEDIT; end;
procedure TWIZARDFORMPASSWORDEDITLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.PASSWORDEDITLABEL; end;
procedure TWIZARDFORMREADYMEMO_R(Self: TWIZARDFORM; var T: TMEMO); begin T := Self.READYMEMO; end;
procedure TWIZARDFORMTYPESCOMBO_R(Self: TWIZARDFORM; var T: TCOMBOBOX); begin T := Self.TYPESCOMBO; end;
procedure TWIZARDFORMBEVEL_R(Self: TWIZARDFORM; var T: TBEVEL); begin T := Self.BEVEL; end;
procedure TWIZARDFORMWizardBitmapImage_R(Self: TWIZARDFORM; var T: TBitmapImage); begin T := Self.WizardBitmapImage; end;
procedure TWIZARDFORMWELCOMELABEL1_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.WELCOMELABEL1; end;
procedure TWIZARDFORMINFOBEFOREMEMO_R(Self: TWIZARDFORM; var T: TRICHEDITVIEWER); begin T := Self.INFOBEFOREMEMO; end;
procedure TWIZARDFORMINFOBEFORECLICKLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.INFOBEFORECLICKLABEL; end;
procedure TWIZARDFORMMAINPANEL_R(Self: TWIZARDFORM; var T: TPANEL); begin T := Self.MAINPANEL; end;
procedure TWIZARDFORMBEVEL1_R(Self: TWIZARDFORM; var T: TBEVEL); begin T := Self.BEVEL1; end;
procedure TWIZARDFORMPAGENAMELABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.PAGENAMELABEL; end;
procedure TWIZARDFORMPAGEDESCRIPTIONLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.PAGEDESCRIPTIONLABEL; end;
procedure TWIZARDFORMWizardSmallBitmapImage_R(Self: TWIZARDFORM; var T: TBitmapImage); begin T := Self.WizardSmallBitmapImage; end;
procedure TWIZARDFORMREADYLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.READYLABEL; end;
procedure TWIZARDFORMFINISHEDLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.FINISHEDLABEL; end;
procedure TWIZARDFORMYESRADIO_R(Self: TWIZARDFORM; var T: TRADIOBUTTON); begin T := Self.YESRADIO; end;
procedure TWIZARDFORMNORADIO_R(Self: TWIZARDFORM; var T: TRADIOBUTTON); begin T := Self.NORADIO; end;
procedure TWIZARDFORMWizardBitmapImage2_R(Self: TWIZARDFORM; var T: TBitmapImage); begin T := Self.WizardBitmapImage2; end;
procedure TWIZARDFORMWELCOMELABEL2_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.WELCOMELABEL2; end;
procedure TWIZARDFORMLICENSELABEL1_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.LICENSELABEL1; end;
procedure TWIZARDFORMLICENSEMEMO_R(Self: TWIZARDFORM; var T: TRICHEDITVIEWER); begin T := Self.LICENSEMEMO; end;
procedure TWIZARDFORMINFOAFTERMEMO_R(Self: TWIZARDFORM; var T: TRICHEDITVIEWER); begin T := Self.INFOAFTERMEMO; end;
procedure TWIZARDFORMINFOAFTERCLICKLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.INFOAFTERCLICKLABEL; end;
procedure TWIZARDFORMCOMPONENTSLIST_R(Self: TWIZARDFORM; var T: TNEWCHECKLISTBOX); begin T := Self.COMPONENTSLIST; end;
procedure TWIZARDFORMCOMPONENTSDISKSPACELABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.COMPONENTSDISKSPACELABEL; end;
procedure TWIZARDFORMBEVELEDLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.BEVELEDLABEL; end;
procedure TWIZARDFORMSTATUSLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.STATUSLABEL; end;
procedure TWIZARDFORMFILENAMELABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.FILENAMELABEL; end;
procedure TWIZARDFORMPROGRESSGAUGE_R(Self: TWIZARDFORM; var T: TNEWPROGRESSBAR); begin T := Self.PROGRESSGAUGE; end;
procedure TWIZARDFORMSELECTDIRLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.SELECTDIRLABEL; end;
procedure TWIZARDFORMSELECTSTARTMENUFOLDERLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.SELECTSTARTMENUFOLDERLABEL; end;
procedure TWIZARDFORMSELECTCOMPONENTSLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.SELECTCOMPONENTSLABEL; end;
procedure TWIZARDFORMSELECTTASKSLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.SELECTTASKSLABEL; end;
procedure TWIZARDFORMLICENSEACCEPTEDRADIO_R(Self: TWIZARDFORM; var T: TRADIOBUTTON); begin T := Self.LICENSEACCEPTEDRADIO; end;
procedure TWIZARDFORMLICENSENOTACCEPTEDRADIO_R(Self: TWIZARDFORM; var T: TRADIOBUTTON); begin T := Self.LICENSENOTACCEPTEDRADIO; end;
procedure TWIZARDFORMUSERINFONAMELABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.USERINFONAMELABEL; end;
procedure TWIZARDFORMUSERINFONAMEEDIT_R(Self: TWIZARDFORM; var T: TEDIT); begin T := Self.USERINFONAMEEDIT; end;
procedure TWIZARDFORMUSERINFOORGLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.USERINFOORGLABEL; end;
procedure TWIZARDFORMUSERINFOORGEDIT_R(Self: TWIZARDFORM; var T: TEDIT); begin T := Self.USERINFOORGEDIT; end;
procedure TWIZARDFORMPreparingErrorBitmapImage_R(Self: TWIZARDFORM; var T: TBitmapImage); begin T := Self.PreparingErrorBitmapImage; end;
procedure TWIZARDFORMPREPARINGLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.PREPARINGLABEL; end;
procedure TWIZARDFORMFINISHEDHEADINGLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.FINISHEDHEADINGLABEL; end;
procedure TWIZARDFORMUSERINFOSERIALLABEL_R(Self: TWIZARDFORM; var T: TNEWSTATICTEXT); begin T := Self.USERINFOSERIALLABEL; end;
procedure TWIZARDFORMUSERINFOSERIALEDIT_R(Self: TWIZARDFORM; var T: TEDIT); begin T := Self.USERINFOSERIALEDIT; end;
procedure TWIZARDFORMTASKSLIST_R(Self: TWIZARDFORM; var T: TNEWCHECKLISTBOX); begin T := Self.TASKSLIST; end;
procedure TWIZARDFORMRUNLIST_R(Self: TWIZARDFORM; var T: TNEWCHECKLISTBOX); begin T := Self.RUNLIST; end;
procedure TWIZARDFORMCurPageID_R(Self: TWIZARDFORM; var T: Integer); begin T := Self.CurPageID; end;
procedure TWIZARDFORMDirBrowseButton_R(Self: TWIZARDFORM; var T: TButton); begin T := Self.DirBrowseButton; end;
procedure TWIZARDFORMGroupBrowseButton_R(Self: TWIZARDFORM; var T: TButton); begin T := Self.GroupBrowseButton; end;
procedure TWIZARDFORMSelectDirBitmapImage(Self: TWIZARDFORM; var T: TBitmapImage); begin T := Self.SelectDirBitmapImage; end;
procedure TWIZARDFORMSelectGroupBitmapImage(Self: TWIZARDFORM; var T: TBitmapImage); begin T := Self.SelectGroupBitmapImage; end;
procedure TWIZARDFORMSelectDirBrowseLabel(Self: TWIZARDFORM; var T: TNewStaticText); begin T := Self.SelectDirBrowseLabel; end;
procedure TWIZARDFORMSelectStartMenuFolderBrowseLabel(Self: TWIZARDFORM; var T: TNewStaticText); begin T := Self.SelectStartMenuFolderBrowseLabel; end;

procedure RegisterWizardForm_R(Cl: TPSRuntimeClassImporter);
begin
  with Cl.Add(TWizardForm) do
  begin
    RegisterPropertyHelper(@TWIZARDFORMCANCELBUTTON_R, nil, 'CANCELBUTTON');
    RegisterPropertyHelper(@TWIZARDFORMNEXTBUTTON_R, nil, 'NEXTBUTTON');
    RegisterPropertyHelper(@TWIZARDFORMBACKBUTTON_R, nil, 'BACKBUTTON');
    RegisterPropertyHelper(@TWIZARDFORMOuterNotebook_R, nil, 'OuterNotebook');
    RegisterPropertyHelper(@TWIZARDFORMInnerNotebook_R, nil, 'InnerNotebook');
    RegisterPropertyHelper(@TWizardFormWelcomePage_R,nil,'WelcomePage');
    RegisterPropertyHelper(@TWizardFormInnerPage_R,nil,'InnerPage');
    RegisterPropertyHelper(@TWizardFormFinishedPage_R,nil,'FinishedPage');
    RegisterPropertyHelper(@TWizardFormLicensePage_R,nil,'LicensePage');
    RegisterPropertyHelper(@TWizardFormPasswordPage_R,nil,'PasswordPage');
    RegisterPropertyHelper(@TWizardFormInfoBeforePage_R,nil,'InfoBeforePage');
    RegisterPropertyHelper(@TWizardFormUserInfoPage_R,nil,'UserInfoPage');
    RegisterPropertyHelper(@TWizardFormSelectDirPage_R,nil,'SelectDirPage');
    RegisterPropertyHelper(@TWizardFormSelectComponentsPage_R,nil,'SelectComponentsPage');
    RegisterPropertyHelper(@TWizardFormSelectProgramGroupPage_R,nil,'SelectProgramGroupPage');
    RegisterPropertyHelper(@TWizardFormSelectTasksPage_R,nil,'SelectTasksPage');
    RegisterPropertyHelper(@TWizardFormReadyPage_R,nil,'ReadyPage');
    RegisterPropertyHelper(@TWizardFormPreparingPage_R,nil,'PreparingPage');
    RegisterPropertyHelper(@TWizardFormInstallingPage_R,nil,'InstallingPage');
    RegisterPropertyHelper(@TWizardFormInfoAfterPage_R,nil,'InfoAfterPage');
    RegisterPropertyHelper(@TWIZARDFORMDISKSPACELABEL_R, nil, 'DISKSPACELABEL');
    RegisterPropertyHelper(@TWIZARDFORMDIREDIT_R, nil, 'DIREDIT');
    RegisterPropertyHelper(@TWIZARDFORMGROUPEDIT_R, nil, 'GROUPEDIT');
    RegisterPropertyHelper(@TWIZARDFORMNOICONSCHECK_R, nil, 'NOICONSCHECK');
    RegisterPropertyHelper(@TWIZARDFORMPASSWORDLABEL_R, nil, 'PASSWORDLABEL');
    RegisterPropertyHelper(@TWIZARDFORMPASSWORDEDIT_R, nil, 'PASSWORDEDIT');
    RegisterPropertyHelper(@TWIZARDFORMPASSWORDEDITLABEL_R, nil, 'PASSWORDEDITLABEL');
    RegisterPropertyHelper(@TWIZARDFORMREADYMEMO_R, nil, 'READYMEMO');
    RegisterPropertyHelper(@TWIZARDFORMTYPESCOMBO_R, nil, 'TYPESCOMBO');
    RegisterPropertyHelper(@TWIZARDFORMBEVEL_R, nil, 'BEVEL');
    RegisterPropertyHelper(@TWIZARDFORMWizardBitmapImage_R, nil, 'WizardBitmapImage');
    RegisterPropertyHelper(@TWIZARDFORMWELCOMELABEL1_R, nil, 'WELCOMELABEL1');
    RegisterPropertyHelper(@TWIZARDFORMINFOBEFOREMEMO_R, nil, 'INFOBEFOREMEMO');
    RegisterPropertyHelper(@TWIZARDFORMINFOBEFORECLICKLABEL_R, nil, 'INFOBEFORECLICKLABEL');
    RegisterPropertyHelper(@TWIZARDFORMMAINPANEL_R, nil, 'MAINPANEL');
    RegisterPropertyHelper(@TWIZARDFORMBEVEL1_R, nil, 'BEVEL1');
    RegisterPropertyHelper(@TWIZARDFORMPAGENAMELABEL_R, nil, 'PAGENAMELABEL');
    RegisterPropertyHelper(@TWIZARDFORMPAGEDESCRIPTIONLABEL_R, nil, 'PAGEDESCRIPTIONLABEL');
    RegisterPropertyHelper(@TWIZARDFORMWizardSmallBitmapImage_R, nil, 'WizardSmallBitmapImage');
    RegisterPropertyHelper(@TWIZARDFORMREADYLABEL_R, nil, 'READYLABEL');
    RegisterPropertyHelper(@TWIZARDFORMFINISHEDLABEL_R, nil, 'FINISHEDLABEL');
    RegisterPropertyHelper(@TWIZARDFORMYESRADIO_R, nil, 'YESRADIO');
    RegisterPropertyHelper(@TWIZARDFORMNORADIO_R, nil, 'NORADIO');
    RegisterPropertyHelper(@TWIZARDFORMWizardBitmapImage2_R, nil, 'WizardBitmapImage2');
    RegisterPropertyHelper(@TWIZARDFORMWELCOMELABEL2_R, nil, 'WELCOMELABEL2');
    RegisterPropertyHelper(@TWIZARDFORMLICENSELABEL1_R, nil, 'LICENSELABEL1');
    RegisterPropertyHelper(@TWIZARDFORMLICENSEMEMO_R, nil, 'LICENSEMEMO');
    RegisterPropertyHelper(@TWIZARDFORMINFOAFTERMEMO_R, nil, 'INFOAFTERMEMO');
    RegisterPropertyHelper(@TWIZARDFORMINFOAFTERCLICKLABEL_R, nil, 'INFOAFTERCLICKLABEL');
    RegisterPropertyHelper(@TWIZARDFORMCOMPONENTSLIST_R, nil, 'COMPONENTSLIST');
    RegisterPropertyHelper(@TWIZARDFORMCOMPONENTSDISKSPACELABEL_R, nil, 'COMPONENTSDISKSPACELABEL');
    RegisterPropertyHelper(@TWIZARDFORMBEVELEDLABEL_R, nil, 'BEVELEDLABEL');
    RegisterPropertyHelper(@TWIZARDFORMSTATUSLABEL_R, nil, 'STATUSLABEL');
    RegisterPropertyHelper(@TWIZARDFORMFILENAMELABEL_R, nil, 'FILENAMELABEL');
    RegisterPropertyHelper(@TWIZARDFORMPROGRESSGAUGE_R, nil, 'PROGRESSGAUGE');
    RegisterPropertyHelper(@TWIZARDFORMSELECTDIRLABEL_R, nil, 'SELECTDIRLABEL');
    RegisterPropertyHelper(@TWIZARDFORMSELECTSTARTMENUFOLDERLABEL_R, nil, 'SELECTSTARTMENUFOLDERLABEL');
    RegisterPropertyHelper(@TWIZARDFORMSELECTCOMPONENTSLABEL_R, nil, 'SELECTCOMPONENTSLABEL');
    RegisterPropertyHelper(@TWIZARDFORMSELECTTASKSLABEL_R, nil, 'SELECTTASKSLABEL');
    RegisterPropertyHelper(@TWIZARDFORMLICENSEACCEPTEDRADIO_R, nil, 'LICENSEACCEPTEDRADIO');
    RegisterPropertyHelper(@TWIZARDFORMLICENSENOTACCEPTEDRADIO_R, nil, 'LICENSENOTACCEPTEDRADIO');
    RegisterPropertyHelper(@TWIZARDFORMUSERINFONAMELABEL_R, nil, 'USERINFONAMELABEL');
    RegisterPropertyHelper(@TWIZARDFORMUSERINFONAMEEDIT_R, nil, 'USERINFONAMEEDIT');
    RegisterPropertyHelper(@TWIZARDFORMUSERINFOORGLABEL_R, nil, 'USERINFOORGLABEL');
    RegisterPropertyHelper(@TWIZARDFORMUSERINFOORGEDIT_R, nil, 'USERINFOORGEDIT');
    RegisterPropertyHelper(@TWIZARDFORMPreparingErrorBitmapImage_R, nil, 'PreparingErrorBitmapImage');
    RegisterPropertyHelper(@TWIZARDFORMPREPARINGLABEL_R, nil, 'PREPARINGLABEL');
    RegisterPropertyHelper(@TWIZARDFORMFINISHEDHEADINGLABEL_R, nil, 'FINISHEDHEADINGLABEL');
    RegisterPropertyHelper(@TWIZARDFORMUSERINFOSERIALLABEL_R, nil, 'USERINFOSERIALLABEL');
    RegisterPropertyHelper(@TWIZARDFORMUSERINFOSERIALEDIT_R, nil, 'USERINFOSERIALEDIT');
    RegisterPropertyHelper(@TWIZARDFORMTASKSLIST_R, nil, 'TASKSLIST');
    RegisterPropertyHelper(@TWIZARDFORMRUNLIST_R, nil, 'RUNLIST');
    RegisterPropertyHelper(@TWIZARDFORMDirBrowseButton_R, nil, 'DirBrowseButton');
    RegisterPropertyHelper(@TWIZARDFORMGroupBrowseButton_R, nil, 'GroupBrowseButton');
    RegisterPropertyHelper(@TWIZARDFORMSelectDirBitmapImage, nil, 'SelectDirBitmapImage');
    RegisterPropertyHelper(@TWIZARDFORMSelectGroupBitmapImage, nil, 'SelectGroupBitmapImage');
    RegisterPropertyHelper(@TWIZARDFORMSelectDirBrowseLabel, nil, 'SelectDirBrowseLabel');
    RegisterPropertyHelper(@TWIZARDFORMSelectStartMenuFolderBrowseLabel, nil,'SelectStartMenuFolderBrowseLabel');
    RegisterPropertyHelper(@TWIZARDFORMCurPageID_R, nil, 'CurPageID');
    RegisterMethod(@TWIZARDFORM.ADJUSTLABELHEIGHT, 'ADJUSTLABELHEIGHT');
    RegisterMethod(@TWIZARDFORM.INCTOPDECHEIGHT, 'INCTOPDECHEIGHT');
  end;
end;

procedure TWizardPageID_R(Self: TWizardPage; var T: Integer); begin T := Self.ID; end;
procedure TWizardPageCaption_R(Self: TWizardPage; var T: String); begin T := Self.Caption; end;
procedure TWizardPageCaption_W(Self: TWizardPage; T: String); begin Self.Caption := T; end;
procedure TWizardPageDescription_R(Self: TWizardPage; var T: String); begin T := Self.Description; end;
procedure TWizardPageDescription_W(Self: TWizardPage; T: String); begin Self.Description := T; end;
procedure TWizardPageSurface_R(Self: TWizardPage; var T: TNewNotebookPage); begin T := Self.Surface; end;
procedure TWizardPageSurfaceHeight_R(Self: TWizardPage; var T: Integer); begin T := Self.SurfaceHeight; end;
procedure TWizardPageSurfaceWidth_R(Self: TWizardPage; var T: Integer); begin T := Self.SurfaceWidth; end;
procedure TWizardPageOnActivate_R(Self: TWizardPage; var T: TWizardPageNotifyEvent); begin T := Self.OnActivate; end;
procedure TWizardPageOnActivate_W(Self: TWizardPage; T: TWizardPageNotifyEvent); begin Self.OnActivate := T; end;
procedure TWizardPageOnBackButtonClick_R(Self: TWizardPage; var T: TWizardPageButtonEvent); begin T := Self.OnBackButtonClick; end;
procedure TWizardPageOnBackButtonClick_W(Self: TWizardPage; T: TWizardPageButtonEvent); begin Self.OnBackButtonClick := T; end;
procedure TWizardPageOnCancelButtonClick_R(Self: TWizardPage; var T: TWizardPageCancelEvent); begin T := Self.OnCancelButtonClick; end;
procedure TWizardPageOnCancelButtonClick_W(Self: TWizardPage; T: TWizardPageCancelEvent); begin Self.OnCancelButtonClick := T; end;
procedure TWizardPageOnNextButtonClick_R(Self: TWizardPage; var T: TWizardPageButtonEvent); begin T := Self.OnNextButtonClick; end;
procedure TWizardPageOnNextButtonClick_W(Self: TWizardPage; T: TWizardPageButtonEvent); begin Self.OnNextButtonClick := T; end;
procedure TWizardPageOnShouldSkipPage_R(Self: TWizardPage; var T: TWizardPageShouldSkipEvent); begin T := Self.OnShouldSkipPage; end;
procedure TWizardPageOnShouldSkipPage_W(Self: TWizardPage; T: TWizardPageShouldSkipEvent); begin Self.OnShouldSkipPage := T; end;

procedure RegisterWizardPage_R(Cl: TIFPSRuntimeClassImporter);
begin
  with Cl.Add(TWizardPage) do
  begin
    RegisterPropertyHelper(@TWizardPageID_R, nil, 'ID');
    RegisterPropertyHelper(@TWizardPageCaption_R, @TWizardPageCaption_W, 'Caption');
    RegisterPropertyHelper(@TWizardPageDescription_R, @TWizardPageDescription_W, 'Description');
    RegisterPropertyHelper(@TWizardPageSurface_R, nil, 'Surface');
    RegisterPropertyHelper(@TWizardPageSurfaceHeight_R, nil, 'SurfaceHeight');
    RegisterPropertyHelper(@TWizardPageSurfaceWidth_R, nil, 'SurfaceWidth');
    RegisterPropertyHelper(@TWizardPageOnActivate_R, @TWizardPageOnActivate_W, 'OnActivate');
    RegisterPropertyHelper(@TWizardPageOnBackButtonClick_R, @TWizardPageOnBackButtonClick_W, 'OnBackButtonClick');
    RegisterPropertyHelper(@TWizardPageOnCancelButtonClick_R, @TWizardPageOnCancelButtonClick_W, 'OnCancelButtonClick');
    RegisterPropertyHelper(@TWizardPageOnNextButtonClick_R, @TWizardPageOnNextButtonClick_W, 'OnNextButtonClick');
    RegisterPropertyHelper(@TWizardPageOnShouldSkipPage_R, @TWizardPageOnShouldSkipPage_W, 'OnShouldSkipPage');
  end;
end;

procedure TInputQueryWizardPageEdits_R(Self: TInputQueryWizardPage; var T: TPasswordEdit; const t1: Integer); begin T := Self.Edits[t1]; end;
procedure TInputQueryWizardPagePromptLabels_R(Self: TInputQueryWizardPage; var T: TNewStaticText; const t1: Integer); begin T := Self.PromptLabels[t1]; end;
procedure TInputQueryWizardPageValues_R(Self: TInputQueryWizardPage; var T: String; const t1: Integer); begin T := Self.Values[t1]; end;
procedure TInputQueryWizardPageSubCaptionLabel_R(Self: TInputQueryWizardPage; var T: TNewStaticText); begin T := Self.SubCaptionLabel; end;
procedure TInputQueryWizardPageValues_W(Self: TInputQueryWizardPage; const T: String; const t1: Integer); begin Self.Values[t1] := T; end;

procedure RegisterInputQueryWizardPage_R(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TInputQueryWizardPage) do
  begin
    RegisterMethod(@TInputQueryWizardPage.Add, 'Add');
    RegisterPropertyHelper(@TInputQueryWizardPageEdits_R,nil,'Edits');
    RegisterPropertyHelper(@TInputQueryWizardPagePromptLabels_R,nil,'PromptLabels');
    RegisterPropertyHelper(@TInputQueryWizardPageSubcaptionLabel_R,nil,'SubCaptionLabel');
    RegisterPropertyHelper(@TInputQueryWizardPageValues_R,@TInputQueryWizardPageValues_W,'Values');
  end;
end;

procedure TInputOptionWizardPageCheckListBox_R(Self: TInputOptionWizardPage; var T: TNewCheckListBox); begin T := Self.CheckListBox; end;
procedure TInputOptionWizardPageSelectedValueIndex_R(Self: TInputOptionWizardPage; var T: Integer); begin T := Self.SelectedValueIndex; end;
procedure TInputOptionWizardPageSelectedValueIndex_W(Self: TInputOptionWizardPage; const T: Integer); begin Self.SelectedValueIndex := T; end;
procedure TInputOptionWizardPageSubCaptionLabel_R(Self: TInputOptionWizardPage; var T: TNewStaticText); begin T := Self.SubCaptionLabel; end;
procedure TInputOptionWizardPageValues_W(Self: TInputOptionWizardPage; const T: Boolean; const t1: Integer); begin Self.Values[t1] := T; end;
procedure TInputOptionWizardPageValues_R(Self: TInputOptionWizardPage; var T: Boolean; const t1: Integer); begin T := Self.Values[t1]; end;

procedure RegisterInputOptionWizardPage_R(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TInputOptionWizardPage) do
  begin
    RegisterMethod(@TInputOptionWizardPage.Add, 'Add');
    RegisterMethod(@TInputOptionWizardPage.AddEx, 'AddEx');
    RegisterPropertyHelper(@TInputOptionWizardPageCheckListBox_R,nil,'CheckListBox');
    RegisterPropertyHelper(@TInputOptionWizardPageSelectedValueIndex_R,@TInputOptionWizardPageSelectedValueIndex_W,'SelectedValueIndex');
    RegisterPropertyHelper(@TInputOptionWizardPageSubcaptionLabel_R,nil,'SubCaptionLabel');
    RegisterPropertyHelper(@TInputOptionWizardPageValues_R,@TInputOptionWizardPageValues_W,'Values');
  end;
end;

procedure TInputDirWizardPageButtons_R(Self: TInputDirWizardPage; var T: TButton; const t1: Integer); begin T := Self.Buttons[t1]; end;
procedure TInputDirWizardPageEdits_R(Self: TInputDirWizardPage; var T: TEdit; const t1: Integer); begin T := Self.Edits[t1]; end;
procedure TInputDirWizardPagePromptLabels_R(Self: TInputDirWizardPage; var T: TNewStaticText; const t1: Integer); begin T := Self.PromptLabels[t1]; end;
procedure TInputDirWizardPageSubCaptionLabel_R(Self: TInputDirWizardPage; var T: TNewStaticText); begin T := Self.SubCaptionLabel; end;
procedure TInputDirWizardPageValues_W(Self: TInputDirWizardPage; const T: String; const t1: Integer); begin Self.Values[t1] := T; end;
procedure TInputDirWizardPageValues_R(Self: TInputDirWizardPage; var T: String; const t1: Integer); begin T := Self.Values[t1]; end;

procedure RegisterInputDirWizardPage_R(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TInputDirWizardPage) do
  begin
    RegisterMethod(@TInputDirWizardPage.Add, 'Add');
    RegisterPropertyHelper(@TInputDirWizardPageButtons_R,nil,'Buttons');
    RegisterPropertyHelper(@TInputDirWizardPageEdits_R,nil,'Edits');
    RegisterPropertyHelper(@TInputDirWizardPagePromptLabels_R,nil,'PromptLabels');
    RegisterPropertyHelper(@TInputDirWizardPageSubcaptionLabel_R,nil,'SubCaptionLabel');
    RegisterPropertyHelper(@TInputDirWizardPageValues_R,@TInputDirWizardPageValues_W,'Values');
  end;
end;

procedure TInputFileWizardPageButtons_R(Self: TInputFileWizardPage; var T: TButton; const t1: Integer); begin T := Self.Buttons[t1]; end;
procedure TInputFileWizardPagePromptLabels_R(Self: TInputFileWizardPage; var T: TNewStaticText; const t1: Integer); begin T := Self.PromptLabels[t1]; end;
procedure TInputFileWizardPageEdits_R(Self: TInputFileWizardPage; var T: TEdit; const t1: Integer); begin T := Self.Edits[t1]; end;
procedure TInputFileWizardPageSubCaptionLabel_R(Self: TInputFileWizardPage; var T: TNewStaticText); begin T := Self.SubCaptionLabel; end;
procedure TInputFileWizardPageValues_W(Self: TInputFileWizardPage; const T: String; const t1: Integer); begin Self.Values[t1] := T; end;
procedure TInputFileWizardPageValues_R(Self: TInputFileWizardPage; var T: String; const t1: Integer); begin T := Self.Values[t1]; end;
procedure TInputFileWizardPageIsSaveButton_W(Self: TInputFileWizardPage; const T: Boolean; const t1: Integer); begin Self.IsSaveButton[t1] := T; end;
procedure TInputFileWizardPageIsSaveButton_R(Self: TInputFileWizardPage; var T: Boolean; const t1: Integer); begin T := Self.IsSaveButton[t1]; end;

procedure RegisterInputFileWizardPage_R(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TInputFileWizardPage) do
  begin
    RegisterMethod(@TInputFileWizardPage.Add, 'Add');
    RegisterPropertyHelper(@TInputFileWizardPageButtons_R,nil,'Buttons');
    RegisterPropertyHelper(@TInputFileWizardPageEdits_R,nil,'Edits');
    RegisterPropertyHelper(@TInputFileWizardPagePromptLabels_R,nil,'PromptLabels');
    RegisterPropertyHelper(@TInputFileWizardPageSubcaptionLabel_R,nil,'SubCaptionLabel');
    RegisterPropertyHelper(@TInputFileWizardPageValues_R,@TInputFileWizardPageValues_W,'Values');
    RegisterPropertyHelper(@TInputFileWizardPageIsSaveButton_R,@TInputFileWizardPageIsSaveButton_W,'IsSaveButton');
  end;
end;

procedure TOutputMsgWizardPageMsgLabel_R(Self: TOutputMsgWizardPage; var T: TNewStaticText); begin T := Self.MsgLabel; end;

procedure RegisterOutputMsgWizardPage_R(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TOutputMsgWizardPage) do
  begin
    RegisterPropertyHelper(@TOutputMsgWizardPageMsgLabel_R,nil,'MsgLabel');
  end;
end;

procedure TOutputMsgMemoWizardPageRichEditViewer_R(Self: TOutputMsgMemoWizardPage; var T: TRichEditViewer); begin T := Self.RichEditViewer; end;
procedure TOutputMsgMemoWizardPageSubCaptionLabel_R(Self: TOutputMsgMemoWizardPage; var T: TNewStaticText); begin T := Self.SubCaptionLabel; end;

procedure RegisterOutputMsgMemoWizardPage_R(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TOutputMsgMemoWizardPage) do
  begin
    RegisterPropertyHelper(@TOutputMsgMemoWizardPageRichEditViewer_R,nil,'RichEditViewer');
    RegisterPropertyHelper(@TOutputMsgMemoWizardPageSubcaptionLabel_R,nil,'SubCaptionLabel');
  end;
end;

procedure TOutputProgressWizardPageMsg1Label_R(Self: TOutputProgressWizardPage; var T: TNewStaticText); begin T := Self.Msg1Label; end;
procedure TOutputProgressWizardPageMsg2Label_R(Self: TOutputProgressWizardPage; var T: TNewStaticText); begin T := Self.Msg2Label; end;
procedure TOutputProgressWizardPageProgressBar_R(Self: TOutputProgressWizardPage; var T: TNewProgressBar); begin T := Self.ProgressBar; end;

procedure RegisterOutputProgressWizardPage_R(CL: TPSRuntimeClassImporter);
begin
  with CL.Add(TOutputProgressWizardPage) do
  begin
    RegisterMethod(@TOutputProgressWizardPage.Hide, 'Hide');
    RegisterPropertyHelper(@TOutputProgressWizardPageMsg1Label_R,nil,'Msg1Label');
    RegisterPropertyHelper(@TOutputProgressWizardPageMsg2Label_R,nil,'Msg2Label');
    RegisterPropertyHelper(@TOutputProgressWizardPageProgressBar_R,nil,'ProgressBar');
    RegisterMethod(@TOutputProgressWizardPage.SetProgress, 'SetProgress');
    RegisterMethod(@TOutputProgressWizardPage.SetText, 'SetText');
    RegisterMethod(@TOutputProgressWizardPage.Show, 'Show');
  end;
end;

procedure RegisterHandCursor_R(Cl: TPSRuntimeClassImporter);
const
  IDC_HAND = MakeIntResource(32649);
begin
  Screen.Cursors[crHand] := LoadCursor(0, IDC_HAND);
end;

function ScriptClassesLibraryRegister_R(ScriptInterpreter: TPSExec): TPSRuntimeClassImporter;
var
  Cl: TPSRuntimeClassImporter;
begin
  Cl := TPSRuntimeClassImporter.Create();
  try
    { Std }
    RIRegisterTObject(Cl);
    RIRegisterTPersistent(Cl);
    RIRegisterTComponent(Cl);

    { Classes }
    RIRegisterTStream(Cl);
    RIRegisterTStrings(Cl, True);
    RIRegisterTStringList(Cl);
    RIRegisterTHandleStream(Cl);
    RIRegisterTFileStream(Cl);

    { Graphics }
    RIRegisterTGraphicsObject(Cl);
    RIRegisterTFont(Cl);
    RIRegisterTCanvas(Cl);
    RIRegisterTPen(Cl);
    RIRegisterTBrush(Cl);
    RIRegisterTGraphic(Cl);
    RIRegisterTBitmap(Cl, True);

    { Controls }
    RIRegisterTControl(Cl);
    RIRegisterTWinControl(Cl);
    RIRegisterTGraphicControl(Cl);
    RIRegisterTCustomControl(Cl);
    RIRegister_TDragObject(Cl);

    { Forms }
    RIRegisterTScrollingWinControl(Cl);
    RIRegisterTForm(Cl);

    { StdCtrls }
    RIRegisterTCustomLabel(Cl);
    RIRegisterTLabel(Cl);
    RIRegisterTCustomEdit(Cl);
    RIRegisterTEdit(Cl);
    RIRegisterTCustomMemo(Cl);
    RIRegisterTMemo(Cl);
    RIRegisterTCustomComboBox(Cl);
    RIRegisterTComboBox(Cl);
    RIRegisterTButtonControl(Cl);
    RIRegisterTButton(Cl);
    RIRegisterTCustomCheckBox(Cl);
    RIRegisterTCheckBox(Cl);
    RIRegisterTRadioButton(Cl);
    RIRegisterTCustomListBox(Cl);
    RIRegisterTListBox(Cl);

    { ExtCtrls }
    RIRegisterTBevel(Cl);
    RIRegisterTCustomPanel(Cl);
    RIRegisterTPanel(Cl);

    { ComObj }
    RIRegister_ComObj(ScriptInterpreter);

    RegisterNewStaticText_R(Cl);
    RegisterNewCheckListBox_R(Cl);
    RegisterNewProgressBar_R(Cl);
    RegisterRichEditViewer_R(Cl);
    RegisterPasswordEdit_R(Cl);
    RegisterCustomFolderTreeView_R(Cl);
    RegisterFolderTreeView_R(Cl);
    RegisterStartMenuFolderTreeView_R(Cl);
    RegisterBitmapImage_R(Cl);

    RegisterNewNotebook_R(Cl);
    RegisterNewNotebookPage_R(Cl);

    RegisterUIStateForm_R(Cl);
    RegisterSetupForm_R(Cl);
    RegisterMainForm_R(Cl);
    RegisterWizardForm_R(Cl);

    RegisterWizardPage_R(Cl);
    RegisterInputQueryWizardPage_R(Cl);
    RegisterInputOptionWizardPage_R(Cl);
    RegisterInputDirWizardPage_R(Cl);
    RegisterInputFileWizardPage_R(Cl);
    RegisterOutputMsgWizardPage_R(Cl);
    RegisterOutputMsgMemoWizardPage_R(Cl);
    RegisterOutputProgressWizardPage_R(Cl);

    RegisterHandCursor_R(Cl);

    RegisterClassLibraryRuntime(ScriptInterpreter, Cl);
  except
    Cl.Free;
    raise;
  end;

  Result := Cl;
end;

end.
