unit SetupEnt;

{
  Inno Setup
  Copyright (C) 1997-2004 Jordan Russell
  Portions by Martijn Laan
  For conditions of distribution and use, see LICENSE.TXT.

  Functions for handling records with embedded long strings

  $jrsoftware: issrc/Projects/SetupEnt.pas,v 1.3 2004/02/16 02:58:31 jr Exp $
}

interface

uses
  Compress;

procedure SEFreeRec(const P: Pointer; const NumStrings: Integer);
procedure SEDuplicateRec(OldP, NewP: Pointer; Bytes: Cardinal;
  const NumStrings: Integer);
procedure SECompressedBlockWrite(const W: TCompressedBlockWriter; var Buf;
  const Count: Cardinal; const NumStrings: Integer);
procedure SECompressedBlockRead(const R: TCompressedBlockReader; var Buf;
  const Count: Cardinal; const NumStrings: Integer);

implementation

procedure SEFreeRec(const P: Pointer; const NumStrings: Integer);
begin
  if P = nil then Exit;
  if NumStrings > 0 then  { Finalize in Delphi versions < 5 can't be called with zero count }
    Finalize(String(P^), NumStrings);
  FreeMem(P);
end;

procedure SEDuplicateRec(OldP, NewP: Pointer; Bytes: Cardinal;
  const NumStrings: Integer);
var
  I: Integer;
begin
  for I := 1 to NumStrings do begin
    String(NewP^) := String(OldP^);
    Inc(Cardinal(OldP), SizeOf(Pointer));
    Inc(Cardinal(NewP), SizeOf(Pointer));
    Dec(Bytes, SizeOf(Pointer));
  end;
  Move(OldP^, NewP^, Bytes);
end;

procedure SECompressedBlockWrite(const W: TCompressedBlockWriter; var Buf;
  const Count: Cardinal; const NumStrings: Integer);
var
  P: Pointer;
  I: Integer;
  Len: Integer;
begin
  P := @Buf;
  for I := 1 to NumStrings do begin
    Len := Length(String(P^));
    W.Write(Len, SizeOf(Len));
    if Len <> 0 then
      W.Write(Pointer(P^)^, Len);
    Inc(Cardinal(P), SizeOf(Pointer));
  end;
  W.Write(P^, Count - (Cardinal(NumStrings) * SizeOf(Pointer)));
end;

procedure SECompressedBlockRead(const R: TCompressedBlockReader; var Buf;
  const Count: Cardinal; const NumStrings: Integer);
var
  P: Pointer;
  I: Integer;
  Len: Integer;
  S: String;
begin
  P := @Buf;
  for I := 1 to NumStrings do begin
    R.Read(Len, SizeOf(Len));
    SetString(S, nil, Len);
    if Len <> 0 then
      R.Read(S[1], Len);
    String(P^) := S;
    Inc(Cardinal(P), SizeOf(Pointer));
  end;
  R.Read(P^, Count - (Cardinal(NumStrings) * SizeOf(Pointer)));
end;

end.
