unit UninstProgressForm;

{
  Inno Setup
  Copyright (C) 1997-2004 Jordan Russell
  Portions by Martijn Laan
  For conditions of distribution and use, see LICENSE.TXT.

  Uninstaller progress form

  $jrsoftware: issrc/Projects/UninstProgressForm.pas,v 1.4 2004/07/02 20:05:54 jr Exp $
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SetupForm, StdCtrls, ExtCtrls, BitmapImage, NewProgressBar, NewStaticText,
  NewNotebook;

type
  TUninstProgressForm = class(TSetupForm)
    OuterNotebook: TNewNotebook;
    InnerPage: TNewNotebookPage;
    InnerNotebook: TNewNotebook;
    InstallingPage: TNewNotebookPage;
    MainPanel: TPanel;
    PageNameLabel: TNewStaticText;
    PageDescriptionLabel: TNewStaticText;
    WizardSmallBitmapImage: TBitmapImage;
    Bevel1: TBevel;
    StatusLabel: TNewStaticText;
    ProgressBar: TNewProgressBar;
    BeveledLabel: TNewStaticText;
    Bevel: TBevel;
    CancelButton: TButton;
  private
    { Private declarations }
    FTitle, FAppName: String;
    FLastRange: Integer;
    procedure WMTimer(var Message: TWMTimer); message WM_TIMER;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
  public
    { Public declarations }
    UpdateTimerExpired: Boolean;
    CloseTimerExpired: Boolean;
    constructor Create(AOwner: TComponent); override;
    constructor Create2(AOwner: TComponent; const Title, AppName: String);
    procedure UpdateProgress(const AProgress, ARange: Integer);
  end;

function CreateUninstProgressForm(const Title, AppName: String): TUninstProgressForm;

implementation

uses
  Main, Msgs, MsgIDs;

{$R *.DFM}

function CreateUninstProgressForm(const Title, AppName: String): TUninstProgressForm;
begin
  Result := TUninstProgressForm.Create2(nil, Title, AppName);
  Result.Show;
end;

{ TUninstProgressForm }

constructor TUninstProgressForm.Create(AOwner: TComponent);
begin
  inherited;

  InitializeFont;
  Center;

  Caption := FTitle;
  PageNameLabel.Font.Style := [fsBold];
  PageNameLabel.Caption := SetupMessages[msgWizardUninstalling];
  PageDescriptionLabel.Caption := FmtSetupMessage1(msgUninstallStatusLabel, FAppName);
  WizardSmallBitmapImage.Bitmap.Canvas.Brush.Color := clWindow;
  WizardSmallBitmapImage.Bitmap.Width := Application.Icon.Width;
  WizardSmallBitmapImage.Bitmap.Height := Application.Icon.Height;
  WizardSmallBitmapImage.Bitmap.Canvas.Draw(0, 0, Application.Icon);
  StatusLabel.Caption := FmtSetupMessage1(msgStatusUninstalling, FAppName);
  if SetupMessages[msgBeveledLabel] <> '' then begin
    BeveledLabel.Caption := ' ' + SetupMessages[msgBeveledLabel] + ' ';
    BeveledLabel.Visible := True;
  end;
  CancelButton.Caption := SetupMessages[msgButtonCancel];

  FLastRange := -1;
end;

constructor TUninstProgressForm.Create2(AOwner: TComponent;
  const Title, AppName: String);
begin
  FTitle := Title;
  FAppName := AppName;
  Create(AOwner);
end;

procedure TUninstProgressForm.CreateParams(var Params: TCreateParams);
begin
  inherited;
  Params.WindowClass.style := Params.WindowClass.style or CS_NOCLOSE;
end;

procedure TUninstProgressForm.CreateWnd;
begin
  inherited;
  SetTimer(Handle, 98, 125, nil);
  SetTimer(Handle, 99, 1000, nil);
end;

procedure TUninstProgressForm.UpdateProgress(const AProgress, ARange: Integer);
begin
  if ARange <> FLastRange then begin
    ProgressBar.Max := ARange;
    FLastRange := ARange;
  end;
  ProgressBar.Position := AProgress;
end;

procedure TUninstProgressForm.WMTimer(var Message: TWMTimer);
begin
  case Message.TimerID of
    98: UpdateTimerExpired := True;
    99: begin
          KillTimer(Handle, 99);
          CloseTimerExpired := True;
        end;
  end;
end;

end.
