; Inno Setup
; Copyright (C) 1997-2007 Jordan Russell. All rights reserved.
; Portions by Martijn Laan
; For conditions of distribution and use, see LICENSE.TXT.
;
; Setup script
;
; $jrsoftware: issrc/setup.iss,v 1.141 2007/10/22 22:24:16 jr Exp $

[Setup]
AppName=Inno Setup
AppId=Inno Setup 5
AppVerName={cm:NameAndVersion,Inno Setup,5.2.2}
AppVersion=5.2.2
AppPublisher=Jordan Russell
AppPublisherURL=http://www.innosetup.com/
AppSupportURL=http://www.innosetup.com/
AppUpdatesURL=http://www.innosetup.com/
VersionInfoCopyright=Copyright (C) 1997-2007 Jordan Russell. Portions Copyright (C) 2000-2007 Martijn Laan.
AppMutex=InnoSetupCompilerAppMutex,Global\InnoSetupCompilerAppMutex
MinVersion=4.1,4.0
DefaultDirName={pf}\Inno Setup 5
DefaultGroupName=Inno Setup 5
AllowNoIcons=yes
Compression=lzma/max
SolidCompression=yes
UninstallDisplayIcon={app}\Compil32.exe
LicenseFile=license.txt
TimeStampsInUTC=yes
TouchDate=none
TouchTime=00:00
WizardImageFile=compiler:WizModernImage-IS.bmp
WizardSmallImageFile=compiler:WizModernSmallImage-IS.bmp

[Languages]
Name: en; MessagesFile: "files\Default.isl"
Name: ba; MessagesFile: "files\Languages\Basque.isl"
Name: br; MessagesFile: "files\Languages\BrazilianPortuguese.isl"
Name: ca; MessagesFile: "files\Languages\Catalan.isl"
Name: cz; MessagesFile: "files\Languages\Czech.isl"
Name: da; MessagesFile: "files\Languages\Danish.isl"
Name: nl; MessagesFile: "files\Languages\Dutch.isl"
Name: fi; MessagesFile: "files\Languages\Finnish.isl"
Name: fr; MessagesFile: "files\Languages\French.isl"
Name: de; MessagesFile: "files\Languages\German.isl"
Name: he; MessagesFile: "files\Languages\Hebrew.isl"
Name: hu; MessagesFile: "files\Languages\Hungarian.isl"
Name: it; MessagesFile: "files\Languages\Italian.isl"
Name: no; MessagesFile: "files\Languages\Norwegian.isl"
Name: pl; MessagesFile: "files\Languages\Polish.isl"
Name: pt; MessagesFile: "files\Languages\Portuguese.isl"
Name: ru; MessagesFile: "files\Languages\Russian.isl"
Name: sl; MessagesFile: "files\Languages\Slovak.isl"
Name: sl2; MessagesFile: "files\Languages\Slovenian.isl"
Name: sp; MessagesFile: "files\Languages\Spanish.isl"

[Messages]
; two "Setup" on the same line looks weird to me, so put a line break in between
en.WelcomeLabel1=Welcome to the Inno Setup%nSetup Wizard

[Code]
function IsISPP(Filename: String): Boolean;
var
  Version: String;
begin
  if GetVersionNumbersString(ExpandConstant('{app}\' + Filename), Version) then
    Result := (Version <> '0.0.0.0')
  else
    Result := False;
end;

[Tasks]
Name: desktopicon; Description: "{cm:CreateDesktopIcon}"; Flags: unchecked
Name: fileassoc; Description: "{cm:AssocFileExtension,Inno Setup,.iss}"

[InstallDelete]
; Older versions created the desktop icon under {userdesktop}
Type: files; Name: "{userdesktop}\Inno Setup Compiler.lnk"

[Files]
Source: "license.txt"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "ishelp\Staging\ISetup.chm"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "files\Compil32.exe"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "files\ISCC.exe"; DestDir: "{app}"; Flags: ignoreversion touch; Check: not IsISPP('ISCC.exe')
Source: "files\ISCmplr.dll"; DestDir: "{app}"; Flags: ignoreversion touch; Check: not IsISPP('ISCmplr.dll')
Source: "files\ISCmplr.dll"; DestDir: "{app}"; DestName: "ISCmplr.dls"; Flags: onlyifdestfileexists ignoreversion touch
Source: "files\Setup.e32"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "files\SetupLdr.e32"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "files\Default.isl"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "files\Languages\Basque.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\BrazilianPortuguese.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Catalan.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Czech.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Danish.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Dutch.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\French.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Finnish.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\German.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Hebrew.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Hungarian.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Italian.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Norwegian.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Polish.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Portuguese.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Russian.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Slovak.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Slovenian.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\Languages\Spanish.isl"; DestDir: "{app}\Languages"; Flags: ignoreversion touch
Source: "files\WizModernImage.bmp"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "files\WizModernImage-IS.bmp"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "files\WizModernSmallImage.bmp"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "files\WizModernSmallImage-IS.bmp"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "files\iszlib.dll"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "files\isunzlib.dll"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "files\isbzip.dll"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "files\isbunzip.dll"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "files\islzma.dll"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "whatsnew.htm"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "ishelp\isfaq.htm"; DestDir: "{app}"; Flags: ignoreversion touch
Source: "Examples\Example1.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\Example2.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\Example3.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\64Bit.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\64BitThreeArch.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\64BitTwoArch.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\Components.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\Languages.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\MyProg.exe"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\MyProg-x64.exe"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\MyProg-IA64.exe"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\MyProg.chm"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\Readme.txt"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\Readme-Dutch.txt"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\Readme-German.txt"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\CodeExample1.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\CodeDlg.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\CodeClasses.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\CodeDll.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\CodeAutomation.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\UninstallCodeDll.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\UninstallCodeExample1.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\MyDll.dll"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\MyDll\C\MyDll.c"; DestDir: "{app}\Examples\MyDll\C"; Flags: ignoreversion touch
Source: "Examples\MyDll\C\MyDll.def"; DestDir: "{app}\Examples\MyDll\C"; Flags: ignoreversion touch
Source: "Examples\MyDll\C\MyDll.dsp"; DestDir: "{app}\Examples\MyDll\C"; Flags: ignoreversion touch
Source: "Examples\MyDll\Delphi\MyDll.dpr"; DestDir: "{app}\Examples\MyDll\Delphi"; Flags: ignoreversion touch
Source: "Examples\ISPPExample1.iss"; DestDir: "{app}\Examples"; Flags: ignoreversion touch
Source: "Examples\ISPPExample1License.txt"; DestDir: "{app}\Examples"; Flags: ignoreversion touch

[Icons]
Name: "{group}\Inno Setup Compiler"; Filename: "{app}\Compil32.exe"; WorkingDir: "{app}"
Name: "{group}\Inno Setup Documentation"; Filename: "{app}\ISetup.chm"
Name: "{group}\Inno Setup FAQ"; Filename: "{app}\isfaq.htm"
Name: "{group}\Inno Setup Revision History"; Filename: "{app}\whatsnew.htm"
Name: "{commondesktop}\Inno Setup Compiler"; Filename: "{app}\Compil32.exe"; WorkingDir: "{app}"; Tasks: desktopicon

[Run]
Filename: "{app}\Compil32.exe"; Parameters: "/ASSOC"; StatusMsg: "{cm:AssocingFileExtension,Inno Setup,.iss}"; Tasks: fileassoc
Filename: "{app}\Compil32.exe"; WorkingDir: "{app}"; Description: "{cm:LaunchProgram,Inno Setup}"; Flags: nowait postinstall skipifsilent

[UninstallRun]
Filename: "{app}\Compil32.exe"; Parameters: "/UNASSOC"; RunOnceId: "RemoveISSAssoc"
