//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#include "stdafx.h"
#define COMPILING_HOOK_DLL
#include "hook.h"
#include "captionbutton.h"
#include "resource.h"
#include <mmsystem.h>

//------------------------------------------------------------------------------
// Shared section
//------------------------------------------------------------------------------
#pragma data_seg(".SHARE")

// hook housekeeping shared variables
volatile HHOOK          g_hGetMessageHook = NULL;
volatile HHOOK          g_hKeyboardHook = NULL;
volatile LONG           g_nCurHookRefCnt = 0;
volatile LONG           g_nKeyboardHookRefCnt = 0;
volatile DWORD          g_callingThreadId = 0;
volatile DWORD          g_dwLastGetCursor = 0;

// cursor shape shared variables
volatile HCURSOR        g_hCursor = NULL;

// user message used to set caption button
volatile UINT           g_msgInstallStopButton = 0;
volatile UINT           g_msgInstallPauseButton = 0;
volatile UINT           g_msgInstallResumeButton = 0;

#pragma data_seg()
#pragma comment(linker, "/SECTION:.SHARE,rws")

//------------------------------------------------------------------------------
// Nonshared
//------------------------------------------------------------------------------
HINSTANCE hInst;
HWND      hwndButttons;
bool      bRemove;

//------------------------------------------------------------------------------
static LRESULT CALLBACK getMessageProc(int nCode, WPARAM wParam, LPARAM lParam);

#define KEYDOWN(ks,vk)    (((ks)[vk]&0x80)!=0)

// -----------------------------------------------------------------------------
BOOL APIENTRY DllMain(HINSTANCE hInstance, DWORD Reason, LPVOID Reserved)
{
  switch (Reason)
  { // reason
  case DLL_PROCESS_ATTACH:
    hInst = hInstance;
    hwndButttons = NULL;
    bRemove = false;
    return TRUE;

  case DLL_PROCESS_DETACH:
    if (hwndButttons) {
      while (captionbtn::removeButton(hwndButttons)) {}
    }
    return TRUE;

  } // reason
  return TRUE;
}

// -----------------------------------------------------------------------------
HOOK_API BOOL installCurHook()
{
  if (InterlockedIncrement((LPLONG)&g_nCurHookRefCnt) == 1) {

    // install the hooks
    g_hGetMessageHook = SetWindowsHookEx(WH_GETMESSAGE, (HOOKPROC)getMessageProc, hInst, 0);

    // get caption message
    g_msgInstallStopButton = RegisterWindowMessage(WM_USER_INSTALL_STOP_BUTTON_NAME);
    g_msgInstallPauseButton = RegisterWindowMessage(WM_USER_INSTALL_PAUSE_BUTTON_NAME);
    g_msgInstallResumeButton = RegisterWindowMessage(WM_USER_INSTALL_RESUME_BUTTON_NAME);

    // thread id
    g_callingThreadId = GetCurrentThreadId();

    // check if failed
    if (!g_hGetMessageHook) {
      uninstallCurHook();
      return FALSE;
    }
  }

  return TRUE;
}


// -----------------------------------------------------------------------------
HOOK_API BOOL uninstallCurHook()
{
  if (InterlockedDecrement((LPLONG)&g_nCurHookRefCnt) == 0) {

    if (g_hGetMessageHook) { 
      UnhookWindowsHookEx(g_hGetMessageHook); 
      g_hGetMessageHook = NULL; 
      g_callingThreadId = 0;
      g_msgInstallStopButton = 0;
      g_msgInstallPauseButton = 0;
      g_msgInstallResumeButton = 0;
    }

    g_hCursor = NULL;
  }

  return TRUE;
}

// -----------------------------------------------------------------------------
static LRESULT CALLBACK getMessageProc(int nCode, WPARAM wParam, LPARAM lParam)
{
  // is this our message ?
  if (nCode == HC_ACTION) {

    LPMSG msg = reinterpret_cast<LPMSG>(lParam);

    if (wParam == PM_REMOVE) {

      if (   msg->message == WM_MOUSEMOVE
          || msg->message == WM_NCMOUSEMOVE
          || msg->message == WM_LBUTTONDOWN
          || msg->message == WM_LBUTTONUP
          || msg->message == WM_MBUTTONDOWN
          || msg->message == WM_MBUTTONUP
          || msg->message == WM_RBUTTONDOWN
          || msg->message == WM_RBUTTONUP) 
      {
        DWORD now = timeGetTime();
        if (now - g_dwLastGetCursor > 100) {
          InterlockedExchange((LPLONG)&g_hCursor, (LONG)GetCursor());
          InterlockedExchange((LPLONG)&g_dwLastGetCursor, now);
        }
      }

      if (msg->message == g_msgInstallStopButton) {
        HWND hwnd = msg->hwnd;
        HBITMAP hBmp = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_STOP));
        captionbtn::insertButton(hwnd, g_callingThreadId, WM_HOTKEY, msg->wParam, msg->lParam, 5, hBmp);
        hwndButttons = hwnd;

        // force refresh
        RECT rc;
        GetWindowRect(hwnd, &rc);
        MapWindowPoints(0, hwnd, (LPPOINT)&rc, 2);
        RedrawWindow(hwnd, &rc, NULL, RDW_FRAME|RDW_INVALIDATE|RDW_UPDATENOW|RDW_ERASENOW);
      }

      if (msg->message == g_msgInstallPauseButton) {
        HWND hwnd = msg->hwnd;
        if (bRemove) {
          captionbtn::removeButton(hwnd);
        }
        HBITMAP hBmp = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_PAUSE));
        captionbtn::insertButton(hwnd, g_callingThreadId, WM_HOTKEY, msg->wParam, msg->lParam, 2, hBmp);
        hwndButttons = hwnd;

        // force refresh
        RECT rc;
        GetWindowRect(hwnd, &rc);
        MapWindowPoints(0, hwnd, (LPPOINT)&rc, 2);
        RedrawWindow(hwnd, &rc, NULL, RDW_FRAME|RDW_INVALIDATE|RDW_UPDATENOW|RDW_ERASENOW);
        bRemove = true;
      }

      if (msg->message == g_msgInstallResumeButton) {
        HWND hwnd = msg->hwnd;
        if (bRemove) {
          captionbtn::removeButton(hwnd);
        }

        HBITMAP hBmp = LoadBitmap(hInst, MAKEINTRESOURCE(IDB_RESUME));
        captionbtn::insertButton(hwnd, g_callingThreadId, WM_HOTKEY, msg->wParam, msg->lParam, 2, hBmp);
        hwndButttons = hwnd;

        // force refresh
        RECT rc;
        GetWindowRect(hwnd, &rc);
        MapWindowPoints(0, hwnd, (LPPOINT)&rc, 2);
        RedrawWindow(hwnd, &rc, NULL, RDW_FRAME|RDW_INVALIDATE|RDW_UPDATENOW|RDW_ERASENOW);
        bRemove = true;
      }
    }

  }

  // call the next handler in the chain
  return CallNextHookEx(g_hGetMessageHook, nCode, wParam, lParam);
}

//------------------------------------------------------------------------------
HOOK_API HCURSOR getCurrentCursorFromHook()
{
  return g_hCursor;
}

