//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_HOOK_H
#define CAMIT_HOOK_H

#ifdef COMPILING_HOOK_DLL
#define HOOK_API  __declspec(dllexport)
#else
#define HOOK_API  __declspec(dllimport)
#endif // COMPILING_HOOK_DLL

extern "C" {

// unique name of message to install buttons
#define WM_USER_INSTALL_STOP_BUTTON_NAME _T("B17E80F1-7419-11D6-A767-00C0F04895FC")
#define WM_USER_INSTALL_PAUSE_BUTTON_NAME _T("67F22023-7423-11D6-A767-00C0F04895FC")
#define WM_USER_INSTALL_RESUME_BUTTON_NAME _T("22720CD8-7427-11D6-A767-00C0F04895FC")

// install hook to check for changing cursor shapes
HOOK_API BOOL installCurHook();

// uninstall hook
HOOK_API BOOL uninstallCurHook();

// get current cursor handle
HOOK_API HCURSOR getCurrentCursorFromHook();

}

#endif // CAMIT_HOOK_H
