# Makefile - hook.dsp

ifndef CFG
CFG=Release
endif
CC=gcc
CFLAGS=
CXX=g++
CXXFLAGS=$(CFLAGS)
RC=windres -O COFF
ifeq "$(CFG)"  "Release"
CFLAGS+=-W -Os -DWIN32 -DNDEBUG -D_WINDOWS
LD=dllwrap --driver-name=c++ --output-lib hook.a
LDFLAGS=
LDFLAGS+=-Wl,--subsystem,windows --image-base "0x2e00000"
LIBS+=-lkernel32 -luser32 -lgdi32 -lwinspool -lcomdlg32 -ladvapi32 -lshell32 -lole32 -loleaut32 -luuid -lodbc32 -lodbccp32 -lodbc32 -lodbccp32 -lwinmm
else
ifeq "$(CFG)"  "Debug"
CFLAGS+=-g -W -O0 -DWIN32 -D_DEBUG -D_WINDOWS
LD=dllwrap --driver-name=c++ --output-lib hook.a
LDFLAGS=
LDFLAGS+=-Wl,--subsystem,windows --image-base "0x2e00000"
LIBS+=-lkernel32 -luser32 -lgdi32 -lwinspool -lcomdlg32 -ladvapi32 -lshell32 -lole32 -loleaut32 -luuid -lodbc32 -lodbccp32 -lodbc32 -lodbccp32 -lWinmm
endif
endif

ifndef TARGET
TARGET=Hook.dll
endif

.PHONY: all
all: $(TARGET)

%.o: %.c
	$(CC) $(CFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cc
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cpp
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cxx
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.res: %.rc
	$(RC) $(CPPFLAGS) -o $@ -i $<

SOURCE_FILES= \
	captionbutton.cpp \
	hook.cpp \
	StdAfx.cpp

HEADER_FILES= \
	captionbutton.h \
	hook.h \
	StdAfx.h

RESOURCE_FILES= \
	hook.rc \
	pause.bmp \
	resource.h \
	stop.bmp

SRCS=$(SOURCE_FILES) $(HEADER_FILES) $(RESOURCE_FILES)  \
	resume.bmp

OBJS=$(patsubst %.rc,%.res,$(patsubst %.cxx,%.o,$(patsubst %.cpp,%.o,$(patsubst %.cc,%.o,$(patsubst %.c,%.o,$(filter %.c %.cc %.cpp %.cxx %.rc,$(SRCS)))))))

$(TARGET): $(OBJS)
	$(LD) $(LDFLAGS) -o $@ $(OBJS) $(LIBS)

.PHONY: clean
clean:
	-rm -f $(OBJS) $(TARGET) Hook.dep

.PHONY: depends
depends:
	-$(CXX) $(CXXFLAGS) $(CPPFLAGS) -MM $(filter %.c %.cc %.cpp %.cxx,$(SRCS)) > Hook.dep

-include Hook.dep

