//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_ARGS_INFO_H
#define CAMIT_ARGS_INFO_H

#include "SmrtHandle.h"
#include "Grabber.h"
#include <MMSystem.h>

namespace camit {

//------------------------------------------------------------------------------
// Class to parse command line arguments
//------------------------------------------------------------------------------
class ArgsInfo
{
public:
    static ArgsInfo&    createInstance(int argc, _TCHAR * const *argv);
    static ArgsInfo&    getInstance();

public:
    // general options
    bool                verbose_;           // verbose feedback
    bool                dumpVideoCodecs_;   // dump video codecs and exit
    bool                dumpAudioDevices_;  // dump audio devices and ids and exit
    bool                disableHardwareAcceleration_;
                                            // disable hardware accel. during recording
    // output file options
    TCHAR               outputFile_[MAX_PATH];  // output file name
    bool                appendSizeToFilename_;  // append frame dimensions to file name
    TCHAR*              clipTitle_;         // clip title (stored in file)
    TCHAR*              clipAuthor_;        // clip author (stored in file)
    TCHAR*              clipCopyright_;     // clip copyright (stored in file)
    TCHAR*              clipDescription_;   // clip description (stored in file)

    // selection of recording area
    bool                fullScreen_;        // o record entire screen
    bool                selectWindow_;      // o manually select recorded window
    bool                selectArea_;        // o manually select area and position
    long                captureAreaWidth_;  // o manually select position
    long                captureAreaHeight_; // 
    TCHAR*              windowTitle_;       // o specify recorded window by title
    HWND                recordedWindow_;    //   -> handle of window

    // user interface during recording
    bool                noCaptionButtons_;  // disable caption buttons in title bars
    COLORREF            frameColor1_;       // capture area frame color 1
    COLORREF            frameColor2_;       // capture area frame color 1
    long                frameWidth_;        // frame width
    long                frameLength_;       // frame length
    DWORD               hotkeyStop_;        // virtual keycode for gloabal "stop" hotkey
    DWORD               hotkeyPause_;       // virtual keycode for gloabal "pause" hotkey
    DWORD               hotkeyResume_;      // virtual keycode for gloabal "resume" hotkey

    // cursor
    HCURSOR             customCursor_;      // custom cursor to be used in recording
    Grabber::Shape      hiliteShape_;       // hilite cursor (shape)
    int                 hiliteSize_;        // size of hiliting
    COLORREF            hiliteColor_;       // color of hiliting

    // audio recording options
    UINT                audioDeviceId_;     // device id (see dumpAudioDevices_, -1 = no audio)
    GUID                audioCodecGuid_;    // GUID of audio codec
    DWORD               audioSamplingFrequency_;    // audio sampling frequency
    WORD                audioChannels_;     // number of audio channels
    WORD                audioResolution_;   // bits / sample

    // video recording options
    long                videoQuality_;      // video quality (0 - 100, applies to lossy codecs only)
    int                 framesPerSec_;      // recorded FPS
    WORD                colorDepth_;        // recorded color depth in bits
    FOURCC              fourCc_;            // FOURCC code of code
    DWORD               videoBitRate_;      // bit rate in kBit/sec 
    DWORD               keyFramePeriodSec_; // number of seconds between key frames

private:

    ArgsInfo(); // use createInstance() to create an ArgsInfo object

    void                init(int argc, _TCHAR * const *argv);
    void                usage() const;
    void                version() const;
    DWORD               parseHotKey(TCHAR* str) const;

    static BOOL CALLBACK enumWindowsProc(HWND hwnd, LPARAM lParam);
};

} // namespace camit

#endif // CAMIT_ARGS_INFO_H

