//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_BIT_MAP_H
#define CAMIT_BIT_MAP_H

#include "IUnknownImpl.h"

namespace camit {

//------------------------------------------------------------------------------
//
// This file declares the BitMap coclass, which wraps BITMAPINFOHEADERs and 
// exposes the INSSBuffer interface. This removes the need for allocating
// and copying to yet another memory buffer when writing the capture samples.
//
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// IBitMap interface
//------------------------------------------------------------------------------
struct CAMIT_NOVTABLE IBitMap : public IUnknown
{
    STDMETHOD(GetBitMapInfoHeader)(LPBITMAPINFOHEADER* ppBmi) PURE;
    STDMETHOD(ReUse(LONG width, LONG height, WORD bits)) PURE;
};

extern const IID IID_IBitMap;

//------------------------------------------------------------------------------
// BitMap coclass
//------------------------------------------------------------------------------
class BitMap : public IUnknownImpl, 
               public IBitMap, 
               public INSSBuffer
{
public:
    // Constructors
    BitMap(LONG width, LONG height, WORD bits);
    BitMap(LPBITMAPINFOHEADER bmi);

    // Called by IUnknownImpl::QueryInterface
    DECLARE_IUNKNOWN;
    STDMETHODIMP        NonDelegatingQueryInterface(REFIID riid, void ** ppv);

    // IBitMap interface
    STDMETHODIMP        GetBitMapInfoHeader(LPBITMAPINFOHEADER* ppBmi);
    STDMETHODIMP        ReUse(LONG width, LONG height, WORD bits);

    // INSSBuffer interface
    STDMETHODIMP        GetLength(DWORD* pdwLength);
    STDMETHODIMP        SetLength(DWORD dwLength);
    STDMETHODIMP        GetMaxLength(DWORD* pdwLength);
    STDMETHODIMP        GetBuffer(BYTE** ppdwBuffer);
    STDMETHODIMP        GetBufferAndLength(BYTE** ppdwBuffer, DWORD* pdwLength);

private:
    // prohibit creation on stack
    BitMap(const BitMap&);
    BitMap& operator=(const BitMap&);
    virtual ~BitMap();

    LPBITMAPINFOHEADER  bmih_;
};

} // namespace camit

#endif // CAMIT_BIT_MAP_H
