//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_CRITICAL_SECTION_H
#define CAMIT_CRITICAL_SECTION_H

namespace camit {

//------------------------------------------------------------------------------
// Helper class encapsulating a critical section
//------------------------------------------------------------------------------
class CriticalSection 
{
public:
    CriticalSection()
    {
        InitializeCriticalSection(&cs_);
    }

    ~CriticalSection()
    {
        DeleteCriticalSection(&cs_);
    }

    void enter() const
    {
        EnterCriticalSection(&cs_);
    }

    void leave() const
    {
        LeaveCriticalSection(&cs_);
    }

    class Lock
    {
    public:
        Lock(const CriticalSection& cs) : 
            cs_(cs)
        {
            cs_.enter();
        }

        ~Lock()
        {
            cs_.leave();
        }

    private:
        Lock(const Lock&);
        Lock& operator=(const Lock&);

        const CriticalSection& cs_;
    };

private:
    mutable CRITICAL_SECTION cs_;
};

} // namespace camit

#endif  // CAMIT_CRITICAL_SECTION_H
