//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_FORMAT_H
#define CAMIT_FORMAT_H

#include "tstring.h"
#include <MMSystem.h>

namespace camit {

//------------------------------------------------------------------------------
// Class to describe the requested audio & video format.
// 
// Important parameters:
//
//  clipTitle_                : a string to set the recording's clip title
//
//  vih.rcSource                : size of recorded area (top/left at 0,0)
//  vih.rcTarget                : size of recorded area (top/left at 0,0)
//  vih.dwBitRate               : recording bitrate in bits / second (typical: 300)
//  vih.AvgTimePerFrame         : time (in ns!) per video frame ( = 10000000 / FPS )
//  vih.bmiHeader               : BITMAPINFOHEADER of captured frames
//  vih.bmiHeader.biCompression : The codec "four-CC" character code
//  
//  dwVideoQuality              : value between 0 - 100 to set quality for lossy codecs
//  dwVideoSecPerKey            : frequency of key frames (typically 8 sec)
//
//  audioCodecGuid_              : WMMEDIASUBTYPE_ACELPnet or WMMEDIASUBTYPE_WMAudioV7
//
//  wfe.nChannels               : stereo ( = 2 ) or mono ( = 1 )
//  wfe.nSamplesPerSec          : sampling frequency
//
//------------------------------------------------------------------------------
class Format 
{
public:
    Format();

    // helper functions
    void                setClipAttributes(TCHAR* title,  TCHAR* author,  TCHAR* copyright, TCHAR* description); 

    void                setBitMapInfoHeader(LPBITMAPINFOHEADER pbmi);  // helper function to set bitmap info header
    void                setVideoCodec(FOURCC fourCC);                  // set codec
    void                setVideoBitRate(DWORD dwBitRate);              // set video bit rate
    void                setVideoFPS(DWORD dwFPS);                      // set FPS
    void                setVideoQuality(DWORD quality);                // set video quality
    void                setVideoSecPerKey(DWORD secPerKey);            // set key frame spacing

    void                setAudioCodec(REFGUID codec);                  // set audio codec
    void                setAudioSamplingRate(DWORD freq);              // set sampling frequency
    void                setAudioChannels(WORD nChannels);              // set audio channels
    void                setAudioResolution(WORD resolution);           // set audio resolution

    void                updateWaveFormat(WAVEFORMATEX& w);

    DWORD               getVideoFPS() const;
    DWORD               getAudioBuffersPerSec() const;

public:
    // general options
    tstring             clipTitle_;
    tstring             clipAuthor_;
    tstring             clipCopyright_;
    tstring             clipDescription_;

    // video format options
    WMVIDEOINFOHEADER   videoInfo_;
    DWORD               videoQuality_;
    DWORD               videoSecPerKey_;

    // audio format options
    GUID                audioCodecGuid_;
    WAVEFORMATEX        waveFormat_;
    WAVEFORMATEX        waveFormatRecorder_;
    int                 audioBuffersPerFrame_;
};

} // namespace camit

#endif // CAMIT_FORMAT_H

