//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_FRAME_WND_H
#define CAMIT_FRAME_WND_H

#include "SmrtHandle.h"

namespace camit {

//------------------------------------------------------------------------------
// Flashing window around captured screen area
//------------------------------------------------------------------------------
class FrameWnd
{
public:
    FrameWnd(const RECT&  rc, 
             int          border = 8, 
             int          edge = 24, 
             COLORREF     clr1 = RGB(255, 255, 180),
             COLORREF     clr2 = RGB(0, 255, 80));

    void                flash(const RECT& rc);
    void                show();
    void                hide();

protected:
    ATOM                registerWndClass();
    void                create();
    void                configureWindowRgn();
    void                paintBorder(COLORREF colorval);
    void                paintInvertedBorder(COLORREF colorval);

private:
    HINSTANCE           m_hInst;
    SmrtWndHandle       m_hWnd;
    RECT                m_rc;
    int                 m_screenSizeX;
    int                 m_screenSizeY;
    int                 m_nBorder;
    int                 m_nEdge;
    COLORREF            m_clr1;
    COLORREF            m_clr2;
    bool                m_bState;
};

} // namespace camit

#endif // CAMIT_FRAME_WND_H
