//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_IUNKNOWN_IMPL_H
#define CAMIT_IUNKNOWN_IMPL_H

#include <Unknwn.h>

namespace camit {

class CAMIT_NOVTABLE IUnknownImpl : public IUnknown
{
public:
    // Constructor
    IUnknownImpl() : refCount_(0) {}

    // QueryInterface
    STDMETHODIMP QueryInterface(REFIID refiid, void **ppv)
    {
        return NonDelegatingQueryInterface(refiid, ppv);
    }

    // AddRef
    STDMETHODIMP_(ULONG) AddRef()
    {
        return InterlockedIncrement((PLONG)&refCount_);
    }

    // Release
    STDMETHODIMP_(ULONG) Release()
    {
        ULONG ul = 0;
        if((ul = InterlockedDecrement((PLONG)&refCount_)) == 0)
        {
            delete this;
        }

        return ul;
    }

    // Get the IUnknown interface
    IUnknown* GetUnknown()
    {
        return static_cast<IUnknown*>(this);
    }

protected:
    // Derived classes need to implement their QueryInterface
    STDMETHOD(NonDelegatingQueryInterface)(REFIID riid, void** ppv)
    {
        if(riid == IID_IUnknown)
        {
            *ppv = static_cast<IUnknown*>(this);
            static_cast<IUnknown*>(this)->AddRef();
            return S_OK;
        }
        else
        {
            *ppv = NULL;
            return E_NOINTERFACE;
        }
    }

    ULONG refCount_;
};

#define DECLARE_IUNKNOWN                                        \
    STDMETHODIMP QueryInterface(REFIID riid, void **ppv) {      \
        return IUnknownImpl::QueryInterface(riid,ppv);          \
    };                                                          \
    STDMETHODIMP_(ULONG) AddRef() {                             \
        return IUnknownImpl::AddRef();                          \
    };                                                          \
    STDMETHODIMP_(ULONG) Release() {                            \
        return IUnknownImpl::Release();                         \
    };



} // namespace camit

#endif // CAMIT_IUNKNOWN_IMPL_H
