//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_SAFE_QUEUE_H
#define CAMIT_SAFE_QUEUE_H

#include "SmrtHandle.h"
#include "CriticalSection.h"
#include <queue>
#include <memory>

namespace camit {

//------------------------------------------------------------------------------
// A thread-safe queue (FIFO) class
//------------------------------------------------------------------------------
template <class T>
class SafeQueue
{
public:
    // constructor
    SafeQueue() {}

    // append new val
    void push(const T& val)
    {
        CriticalSection::Lock lock(cs_);
        queue_.push(val);
    }

    // get first in queue
    T& front()
    {
        CriticalSection::Lock lock(cs_);
        return queue_.front();
    }

    // remove first val in queue
    void pop()
    {
        CriticalSection::Lock lock(cs_);
        queue_.pop();
    }

    // check if queue empty
    bool empty() const 
    {
        CriticalSection::Lock lock(cs_);
        return queue_.empty();
    }

    // check size
    size_t size() const
    {
        CriticalSection::Lock lock(cs_);
        return queue_.size();
    }

private:
    CriticalSection   cs_;
    std::queue<T>     queue_;
};

} // namespace camit

#endif  // CAMIT_SAFE_QUEUE_H
