//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_SOUND_BUFFER_H
#define CAMIT_SOUND_BUFFER_H

#include "IUnknownImpl.h"
#include <Mmsystem.h>

namespace camit {

//------------------------------------------------------------------------------
//
// This file declares the SoundBuffer coclass, which wraps WAVEHDR and 
// exposes the INSSBuffer interface. This removes the need for allocating
// and copying to yet another memory buffer when writing the recorded samples.
//
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// ISoundBuffer interface
//------------------------------------------------------------------------------
struct CAMIT_NOVTABLE ISoundBuffer : public IUnknown
{
    // extract the ISoundBuffer pointer from the header
    static HRESULT      GetInterfaceFromHeader(LPWAVEHDR, ISoundBuffer**);

    STDMETHOD(GetPreparedHeader)(HWAVEIN hInputDev, LPWAVEHDR* ppwhdr) PURE;
    STDMETHOD(UnprepareHeader)(HWAVEIN hInputDev) PURE;
};

extern const IID IID_ISoundBuffer;

//------------------------------------------------------------------------------
// SoundBuffer coclass
//------------------------------------------------------------------------------
class SoundBuffer : public IUnknownImpl,
                    public ISoundBuffer,
                    public INSSBuffer
{
public:
    SoundBuffer(size_t size);

    // IUknown implementation
    DECLARE_IUNKNOWN;
    STDMETHODIMP        NonDelegatingQueryInterface(REFIID riid, void ** ppv);

    // ISoundBuffer interface
    STDMETHODIMP        GetPreparedHeader(HWAVEIN hInputDev, LPWAVEHDR* ppwhdr);
    STDMETHODIMP        UnprepareHeader(HWAVEIN hInputDev);

    // INSSBuffer interface
    STDMETHODIMP        GetLength(DWORD* pdwLength);
    STDMETHODIMP        SetLength(DWORD dwLength);
    STDMETHODIMP        GetMaxLength(DWORD* pdwLength);
    STDMETHODIMP        GetBuffer(BYTE** ppdwBuffer);
    STDMETHODIMP        GetBufferAndLength(BYTE** ppdwBuffer, DWORD* pdwLength);

private:
    SoundBuffer& operator=(const SoundBuffer&);
    SoundBuffer(const SoundBuffer& rhs);
    virtual ~SoundBuffer();

private:
    WAVEHDR             waveHeader_;
    LPBYTE              buffer_;
};

//------------------------------------------------------------------------------
inline HRESULT ISoundBuffer::GetInterfaceFromHeader(LPWAVEHDR lpwvhdr, ISoundBuffer** ppISoundBuffer)
{
    if (!ppISoundBuffer)
        return E_POINTER;

    if (!(lpwvhdr->dwFlags & WHDR_PREPARED) || (lpwvhdr->dwUser == 0))
        return E_NOINTERFACE;

    *ppISoundBuffer = reinterpret_cast<ISoundBuffer*>(lpwvhdr->dwUser);
    (*ppISoundBuffer)->AddRef();
    return S_OK;
}

} // namespace camit

#endif  // CAMIT_SOUND_BUFFER_H


