//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_WAVE_RECORDER_H
#define CAMIT_WAVE_RECORDER_H

#include "SafeQueue.h"
#include "SmrtHandle.h"
#include "SoundBuffer.h"
#include "Format.h"
#include <Mmsystem.h>
#include <list>

namespace camit {

//------------------------------------------------------------------------------
// A filled sound buffer, stamped with the recording time
//------------------------------------------------------------------------------
typedef std::pair<DWORD, CComPtr<ISoundBuffer> > StampedSoundBuffer;

//------------------------------------------------------------------------------
// FIFO of stamped sound buffers
//------------------------------------------------------------------------------
typedef SafeQueue<StampedSoundBuffer> SoundQueue;

//------------------------------------------------------------------------------
// Class responsible for recording the wave input
//------------------------------------------------------------------------------
class WaveRecorder
{
public:
    // constructor
    WaveRecorder(SoundQueue& queue);

    // destructor
    ~WaveRecorder();

    // select closest recording format
    bool                selectFormat(UINT_PTR       uDeviceID, 
                                     DWORD          nSamplesPerSec, 
                                     WORD           wBitsPerSample,
                                     WORD           nChannels,
                                     WAVEFORMATEX&  wfeRecorder );
    // start recording
    bool                start(UINT          uDeviceID, 
                              const Format& fmt,
                              HANDLE        hBufferAvailable, 
                              DWORD         startTimeMs = 0);

    // stop/pause recording
    void                stop();

    // resume recording
    bool                resume();

    // dump valid recording devices
    static void         dumpAudioDevices();

    // dump supported recoding formats
    static void         dumpRecordingFormats(UINT_PTR uDeviceID);

protected:
    // thread entry stub
    static unsigned int WINAPI  threadProcStub(LPVOID lp);

    // thread entry
    unsigned int        threadProc(LPVOID lp);

    // received wave data
    void                onMmWimData(HWAVEIN hInputDev, WAVEHDR* lpwvhdr);

    // send a free buffer to pipeline
    bool                addNewBuffer(HWAVEIN hInputDev);

private:
    SmrtWin32Handle     thread_;
    SmrtWin32Handle     stopEvent_;
    HANDLE              bufferAvailableEvent_;
    unsigned            pendingBuffers_;    // buffers sent to recorder
    DWORD               samplingTime_;
    DWORD               buffersPerSec_;
    UINT                deviceId_;
    WAVEFORMATEX        waveFormat_;
    HWAVEIN             inputDevice_;
    SoundQueue&         sampleQueue_;       // queue of recorded sound samples
};

} // namespace camit

#endif  // CAMIT_WAVE_RECORDER_H
