//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_WINDOW_FINDER_H
#define CAMIT_WINDOW_FINDER_H

namespace camit {

class WindowFinder
{
public:
    WindowFinder();

    ~WindowFinder();

    HWND                startsearchWindowDialog(HWND hwndMain);

protected:

    long                searchWindow(HWND hwndDialog);

    BOOL                init();

    BOOL                uninit();

    BOOL                initResources();

    BOOL                uninitResources();

    BOOL                checkWindowValidity(HWND hwndDialog, HWND hwndToCheck);

    long                doMouseMove(HWND    hwndDialog,
                                    UINT    message,
                                    WPARAM  wParam,
                                    LPARAM  lParam);

    long                doMouseUp(HWND    hwndDialog,
                                  UINT    message,
                                  WPARAM  wParam,
                                  LPARAM  lParam);

    BOOL                setFinderToolImage(HWND hwndDialog, BOOL bSet);

    BOOL                moveCursorPositionToBullsEye(HWND hwndDialog);

    long                refreshWindow(HWND hwndWindowToBeRefreshed);

    long                highlightFoundWindow(HWND hwndDialog, HWND hwndFoundWindow);

    static BOOL CALLBACK searchWindowDialogProc(HWND    hwndDlg,
                                                UINT    uMsg,
                                                WPARAM  wParam,
                                                LPARAM  lParam);
private:
    HINSTANCE           moduleHandle_;
    HWND                mainWindow_;
    HANDLE              applicationMutex_;
    DWORD               lastError_;
    BOOL                searchWindowStarted_;
    HCURSOR             searchWindowCursor_;
    HCURSOR             previousCursor_;
    HBITMAP             finderIconFilled_;
    HBITMAP             finderIconEmpty_;
    HWND                foundWindow_;
    HPEN                pen_;
};

} // namespace camit

#endif  // CAMIT_WINDOW_FINDER_H
