//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_STDAFX_H
#define CAMIT_STDAFX_H

#define WIN32_LEAN_AND_MEAN

// we require at least NT4.0 or Windows 98
#define _WIN32_WINDOWS      0x0410
#define WINVER              0x0400

#include <Windows.h>
#include <tchar.h>
#include <stdio.h>

#ifndef ASSERT
# include <assert.h>
# define ASSERT(x) assert(x)
#endif

#include <unknwn.h>
#include "CComPtr.h"
#include "ComError.h"

// include compiler specifics
#include "compiler.h"

// disable stupid warnigs
#pragma warning(disable: 4786) // "identifier was truncated in the debug information"

// Windows Media Format SDK
#include <wmsdk.h>
// If this include statement fails, you need to download the Windows Media Format
// SDK from http://wmlicense.smdisp.net/v9sdk/ .
// 
// You then have to add the include directory of the SDK to the list of searched
// include paths, and the lib directory to the list of searched library paths.

// Convert a Win32 error code to a HRESULT
#define CAMIT_HRESULT_FROM_WIN32(x) \
    ((HRESULT)(x) <= 0 \
        ? ((HRESULT)(x)) \
        : ((HRESULT) (((x) & 0x0000FFFF) | (FACILITY_WIN32 << 16) | 0x80000000)))

// DIBSIZE calculates the number of bytes required by an image
#ifndef DIBSIZE
# define WIDTHBYTES(bits) ((DWORD)(((bits)+31) & (~31)) / 8)
# define DIBWIDTHBYTES(bi) (DWORD)WIDTHBYTES((DWORD)(bi).biWidth * (DWORD)(bi).biBitCount)
# define _DIBSIZE(bi) (DIBWIDTHBYTES(bi) * (DWORD)(bi).biHeight)
# define DIBSIZE(bi) ((bi).biHeight < 0 ? (-1)*(_DIBSIZE(bi)) : _DIBSIZE(bi))
#endif

#endif // CAMIT_STDAFX_H

