//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_TSTRING_H
#define CAMIT_TSTRING_H

#include <string>
#include <vector>
#include <string.h>

namespace camit {

typedef std::basic_string<TCHAR> tstring;

#ifdef _UNICODE
#   define A2W(arg) (arg)
#else
class A2W
{
public:
    A2W(const char* str)
    {
        int len = static_cast<int>(strlen(str));
        buf_.resize(len + 1);
        int cnt = MultiByteToWideChar(CP_ACP, 0, str, len, &buf_[0], len);
        buf_[cnt] = '\0';
    }

    operator LPCWSTR() const
    {
        return &buf_[0];
    }

private:
    A2W();
    A2W(const A2W&);
    A2W& operator=(const A2W&);

    std::vector<WCHAR>  buf_;
};
#endif

} // namespace camit

#endif // CAMIT_TSTRING_H
