//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_UTIL_H
#define CAMIT_UTIL_H

namespace camit {

#define SWAP(x, y)  ((x) ^= (y) ^= (x) ^= (y))

//------------------------------------------------------------------------------
// Normalize rectangle
//------------------------------------------------------------------------------
inline void normalizeRect(RECT& rect)
{
    if (rect.right < rect.left) SWAP(rect.right, rect.left);
    if (rect.bottom < rect.top) SWAP(rect.bottom, rect.top);
}

//------------------------------------------------------------------------------
// Constrain rectangle to max width & height
//------------------------------------------------------------------------------
inline void trimRect(RECT& rect, int maxWidth, int maxHeight)
{
    normalizeRect(rect);

    int width = ((rect.right) - (rect.left));
    int height = ((rect.bottom) - (rect.top));

    if (width > maxWidth) 
    {
        rect.left = 0;
        rect.right = maxWidth;
    }

    if (height > maxHeight) 
    {
        rect.top = 0;
        rect.bottom = maxHeight;
    }

    if (rect.left < 0) 
    {
        rect.left = 0;
        rect.right = width;
    }

    if (rect.top < 0)
    {
        rect.top = 0;
        rect.bottom = height;
    }

    if (rect.right > maxWidth)
    {
        rect.right = maxWidth;
        rect.left = maxWidth - width;
    }

    if (rect.bottom > maxHeight)
    {
        rect.bottom = maxHeight;
        rect.top = maxHeight - height;
    }
}

//------------------------------------------------------------------------------
// Align rectangle
//------------------------------------------------------------------------------
inline bool alignRect(long align, long maxX, long maxY, RECT& rc)
{
    long width   = rc.right - rc.left;
    long wm      = width % align;
    long height  = rc.bottom - rc.top;
    long hm      = height % align;

    if (wm == 0 && hm == 0)
        return false;

    if (wm) 
    {
        width += align - wm;
        if (width > maxX) 
        {
            width -= align;
        }
        rc.right   = rc.left + width;
    }

    if (hm) 
    {
        height += align - hm;
        if (height > maxY)
        {
            height -= align;
        }
        rc.bottom  = rc.top + height;
    }

    return true;
}

} // namespace camit

#endif  // CAMIT_UTIL_H
