//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#include "stdafx.h"
#include "Format.h"

namespace camit {

//------------------------------------------------------------------------------
Format::Format() :
    audioBuffersPerFrame_(1)
{
    ZeroMemory(&waveFormat_, sizeof(WAVEFORMATEX));
    waveFormat_.nChannels = 1;
    waveFormat_.nSamplesPerSec = 8000;
    waveFormat_.wBitsPerSample = 8;
    updateWaveFormat(waveFormat_);

    ZeroMemory(&waveFormatRecorder_, sizeof(WAVEFORMATEX));
    waveFormatRecorder_.nChannels = 1;
    waveFormatRecorder_.nSamplesPerSec = 8000;
    waveFormatRecorder_.wBitsPerSample = 8;
    updateWaveFormat(waveFormatRecorder_);
}

//------------------------------------------------------------------------------
void Format::setClipAttributes(TCHAR* title, TCHAR* author, TCHAR* copyright, TCHAR* description)
{
    clipTitle_ = (title ? title : _T(""));
    clipAuthor_ = (author ? author : _T(""));
    clipCopyright_ = (copyright ? copyright : _T(""));
    clipDescription_ = (description ? description : _T(""));
}

//------------------------------------------------------------------------------
void Format::setBitMapInfoHeader(LPBITMAPINFOHEADER pbmi) 
{
    // save codec info
    DWORD savedCodec = videoInfo_.bmiHeader.biCompression;

    // copy new BMI
    CopyMemory(&videoInfo_.bmiHeader, pbmi, sizeof(BITMAPINFOHEADER));

    // restore codec
    videoInfo_.bmiHeader.biCompression = savedCodec;

    SetRect(&videoInfo_.rcSource, 0, 0, videoInfo_.bmiHeader.biWidth, videoInfo_.bmiHeader.biHeight);
    SetRect(&videoInfo_.rcTarget, 0, 0, videoInfo_.bmiHeader.biWidth, videoInfo_.bmiHeader.biHeight);
}

//------------------------------------------------------------------------------
void Format::setVideoCodec(FOURCC fourCC)
{
    videoInfo_.bmiHeader.biCompression = fourCC;
}

//------------------------------------------------------------------------------
void Format::setVideoFPS(DWORD dwFPS)
{
    videoInfo_.AvgTimePerFrame = (LONGLONG)(INT64_C(10000000) / dwFPS);
}

//------------------------------------------------------------------------------
void Format::setVideoBitRate(DWORD dwBitRate)
{
    videoInfo_.dwBitRate = dwBitRate;
}

//------------------------------------------------------------------------------
void Format::setVideoQuality(DWORD quality)
{
    videoQuality_ = quality;
}

//------------------------------------------------------------------------------
void Format::setVideoSecPerKey(DWORD secPerKey)
{
    videoSecPerKey_ = secPerKey;
}

//------------------------------------------------------------------------------
DWORD Format::getVideoFPS() const
{
    return (DWORD)(INT64_C(10000000) / videoInfo_.AvgTimePerFrame);
}

//------------------------------------------------------------------------------
DWORD Format::getAudioBuffersPerSec() const
{
    return audioBuffersPerFrame_ * getVideoFPS();
}

//------------------------------------------------------------------------------
void Format::setAudioCodec(REFGUID codec)
{
    audioCodecGuid_ = codec;
}

//------------------------------------------------------------------------------
void Format::setAudioChannels(WORD nChannels)
{
    waveFormat_.nChannels = nChannels;
    updateWaveFormat(waveFormat_);
}

//------------------------------------------------------------------------------
void Format::setAudioSamplingRate(DWORD freq)
{
    waveFormat_.nSamplesPerSec = freq;
    updateWaveFormat(waveFormat_);
}

//------------------------------------------------------------------------------
void Format::setAudioResolution(WORD resolution)
{
    waveFormat_.wBitsPerSample = resolution;
    updateWaveFormat(waveFormat_);
}

//------------------------------------------------------------------------------
void Format::updateWaveFormat(WAVEFORMATEX& w)
{
    w.wFormatTag      = WAVE_FORMAT_PCM;
    w.nBlockAlign     = w.nChannels * w.wBitsPerSample / 8;
    w.nAvgBytesPerSec = w.nSamplesPerSec * w.nBlockAlign;
    w.cbSize          = 0;
}


} // namespace camit

