//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#include "stdafx.h"
#include "SavedBmp.h"

namespace camit {

//------------------------------------------------------------------------------
SavedBmp::SavedBmp() :
    bitmap_(NULL)
{ }

//------------------------------------------------------------------------------
SavedBmp::~SavedBmp()
{
    release();
}

//------------------------------------------------------------------------------
void SavedBmp::save(HDC hdc, HDC hdcbits, int x, int y, int dx, int dy)
{
    release();
    x_ = x;
    y_ = y;
    width_ = dx;
    height_ = dy;

    bitmap_ = (HBITMAP)CreateCompatibleBitmap(hdc, dx, dy);

    HBITMAP oldBmp = (HBITMAP)SelectObject(hdcbits, bitmap_);
    BitBlt(hdcbits, 0, 0, dx, dy, hdc, x, y, SRCCOPY);
    SelectObject(hdcbits, oldBmp);
}

//------------------------------------------------------------------------------
void SavedBmp::restore(HDC hdc, HDC hdcbits)
{
    if (bitmap_) 
    {
        HBITMAP oldBmp = (HBITMAP)SelectObject(hdcbits, bitmap_);
        BitBlt(hdc, x_, y_, width_, height_, hdcbits, 0, 0, SRCCOPY);
        SelectObject(hdcbits, oldBmp);

        release();   
    }
}

//------------------------------------------------------------------------------
void SavedBmp::release()
{
    if (bitmap_) 
    {
        DeleteObject(bitmap_);
        bitmap_ = NULL;
    }
}

} // namespace camit

