//------------------------------------------------------------------------------
//
// Copyright (C) 2009, Gil da Costa
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------

#include "stdafx.h"
#include "TimeStamp.h"
#include <mmsystem.h>
#include <string.h>


namespace camit {

// size in TCHAR
#define CAMIT_SIZEOF( x )   ( sizeof( (x) ) / sizeof( char ) )



/*static*/ int      TimeStamp::instancesNumber_ = 0;
/*static*/ HFONT    TimeStamp::hFont_ = NULL;



TimeStamp::TimeStamp()
         : resolution_( 1 /*ms*/ ),
           frameCount_( 0 ),
           color_( RGB( 255, 0, 255 ) )  // pink
{
    if ( instancesNumber_++ == 0 )
    {
        HANDLE      hProcess;
        HANDLE      hThread;
        DWORD       old_process_priority;
        int         old_thread_priority;
        FILETIME    ft1;
        FILETIME    ft2;
        LOGFONT     lf;


        timeBeginPeriod( resolution_ );

        // For better time mesurement, we need to have (temporarily) the highest possible priority
        hProcess = GetCurrentProcess(); // no need to close these handles
        hThread = GetCurrentThread();

        old_process_priority = GetPriorityClass( hProcess );
        old_thread_priority = GetThreadPriority( hThread );

        if ( SetPriorityClass( hProcess, REALTIME_PRIORITY_CLASS ) == 0 )
        {
            // we need to have administrator rights in order to raise process to Real Time priority.
            SetPriorityClass( hProcess, HIGH_PRIORITY_CLASS );
        }

        if ( SetThreadPriority( hThread, THREAD_PRIORITY_TIME_CRITICAL ) == 0 )
        {
            SetThreadPriority( hThread, THREAD_PRIORITY_HIGHEST );
        }


        // Wait for the beginning of a Windows tick.
        GetSystemTimeAsFileTime( &ft1 );
        do
        {
            GetSystemTimeAsFileTime( &ft2 );
        } while ( ft2.dwLowDateTime == ft1.dwLowDateTime );
        hiResRef_ = timeGetTime();

        // restore original priorities as soon as possible
        SetThreadPriority( hThread, old_thread_priority );
        SetPriorityClass( hProcess, old_process_priority );

        loResRef_.HighPart = ft2.dwHighDateTime;
        loResRef_.LowPart = ft2.dwLowDateTime;


        // Creation of the font used for timestamping
        memset( &lf, 0, sizeof( lf ) );
        // Fill-in only non-default attributes.
        lf.lfHeight = 24;
        lf.lfWidth = 0;
        lf.lfEscapement = 0;
        lf.lfOrientation = 0;
        lf.lfWeight = FW_BOLD;
        lf.lfItalic = FALSE;
        lf.lfUnderline = FALSE;
        lf.lfStrikeOut = FALSE;
        lf.lfCharSet = DEFAULT_CHARSET;
        lf.lfOutPrecision = OUT_DEFAULT_PRECIS;
        lf.lfClipPrecision = CLIP_DEFAULT_PRECIS;
        lf.lfQuality = ANTIALIASED_QUALITY;
        lf.lfPitchAndFamily = DEFAULT_PITCH;
        _tcscpy( lf.lfFaceName, "Courier New" );

        hFont_ = CreateFontIndirect( &lf );
    }
}

TimeStamp::~TimeStamp()
{
    if ( --instancesNumber_ == 0 )
    {
        timeEndPeriod( resolution_ );

        DeleteObject( hFont_ );
    }
}

// hiResRef_ will overflow every 49 days...
// We make the assumption that a Windows PC must be rebooted much often than this :-)
void    TimeStamp::stamp( HDC hdc, int x, int y, bool useframecount )
{
    CHAR            stampbuffer[ CAMIT_SIZEOF( _T( "2009-12-07 17:38:45.999 #00000" ) ) ];
    int             oldbkmode;
    COLORREF        oldcolor;
    HGDIOBJ         oldfont;
    DWORD           dwNow;
    ULARGE_INTEGER  uliNow;
    FILETIME        ftNow;
    SYSTEMTIME      stNow;

    _sntprintf( stampbuffer, CAMIT_SIZEOF( stampbuffer ), "2009-12-07 13:13:19.123 #%u", frameCount_ );

    if ( useframecount )
    {
        frameCount_++;
    }

    oldfont = SelectObject( hdc, hFont_ );
    oldbkmode = SetBkMode( hdc, TRANSPARENT );
    oldcolor = SetTextColor( hdc, color_ );


    dwNow = timeGetTime();

    uliNow.QuadPart =   loResRef_.QuadPart
                        +
                        (
                            (
                                dwNow
                                -
                                hiResRef_
                            )
                            *
                            10000UL         // from ms to 100s ns
                        );
    ftNow.dwHighDateTime = uliNow.HighPart;
    ftNow.dwLowDateTime = uliNow.LowPart;

    FileTimeToSystemTime( &ftNow, &stNow );

    _sntprintf( stampbuffer,
                CAMIT_SIZEOF( stampbuffer ),
                "%04u-%02u-%02u %02u:%02u:%02u.%03u #%05u",
                stNow.wYear,
                stNow.wMonth,
                stNow.wDay,
                stNow.wHour,
                stNow.wMinute,
                stNow.wSecond,
                stNow.wMilliseconds,
                frameCount_ );

 	TextOut( hdc, x, y, stampbuffer, _tcsclen( stampbuffer ) );

    SetTextColor( hdc, oldcolor );
    SetBkMode( hdc, oldbkmode );
    SelectObject( hdc, oldfont );
}

} // namespace camit
