//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#include "stdafx.h"
#include "CamIt.h"
#include "ArgsInfo.h"
#include "WMProfiles.h"
#include "accel.h"

using namespace camit;

// -----------------------------------------------------------------------------
//  Main program entry
// -----------------------------------------------------------------------------
int __cdecl _tmain(int argc, _TCHAR** argv, _TCHAR** envp)
{
    AccelerationLevel level = ACCELERATION_INVALID;
    if (FAILED(CoInitialize(NULL))) exit(1);

    try 
    {

        // parse options
        ArgsInfo& args = ArgsInfo::createInstance(argc, argv);

        //
        // dump video codecs and exit
        //
        if (args.dumpVideoCodecs_) 
        {
            // dump the video codecs
            WMProfiles prf;
            prf.dumpCodecs(WMMEDIATYPE_Video);
        }

        //
        // dump audio recording devices and exit
        //
        else if (args.dumpAudioDevices_) 
        {
            // dump the audio devices
            WaveRecorder::dumpAudioDevices();
        }

        //
        // record and exit
        //
        else if (args.outputFile_) 
        {

            CamIt camIt;

            // select captured area
            if (args.recordedWindow_) 
            {
                camIt.setRecordedWindow(args.recordedWindow_);
            }
            else if (args.selectArea_) 
            {
                camIt.chooseRecordedArea();
            }
            else if (args.captureAreaHeight_ > 0 && args.captureAreaWidth_ > 0) 
            {
                camIt.chooseRecordedArea(args.captureAreaHeight_, args.captureAreaWidth_);
            }
            else if (args.fullScreen_) 
            {
                camIt.setFullScreen();
            }
            else if (args.selectWindow_) 
            {
                if (!camIt.chooseRecordedWindow())
                    goto exit;
            }
            else 
            {
                camIt.chooseRecordedArea();
            }

            // disable hardware acceleration
            if (args.disableHardwareAcceleration_) 
            {
                if (getAccelerationLevel(level) && level != ACCELERATION_NONE) 
                {
                    setAccelerationLevel(ACCELERATION_NONE);
                }
                else 
                {
                    level = ACCELERATION_INVALID;
                }
            }

            // record
            camIt.record(args);

        }
    }
    catch (const ComError&e) 
    {

        switch (e.hr_) 
        {
        case NS_E_FILE_OPEN_FAILED:
            MessageBox(NULL, _T("Unable to create output file.\n"), _T("Recording Error"), MB_OK | MB_ICONWARNING);
            break;

        default:
            _tprintf(_T("%hs\n"), e.what());
            break;
        }
    }

exit:
    CoUninitialize();

    if (level != ACCELERATION_INVALID) 
    {
        setAccelerationLevel(level);
    }

    ExitProcess(0);
}


