# Makefile - camit.dsp

ifndef CFG
CFG=Debug
endif

ifndef WMFSDK
WMFSDK=/WMSDK/WMFSDK9
endif

CC=gcc
CFLAGS=
CXX=g++
CXXFLAGS=$(CFLAGS)
RC=windres -O COFF --include-dir=res
ifeq "$(CFG)"  "Debug"
CFLAGS+=-I include -isystem $(WMFSDK)/include -g -W -Wno-ctor-dtor-privacy -O0 -DWIN32 -D_DEBUG -DDEBUG -D_CONSOLE -DUSE_STDIO -D_MBCS
LD=$(CXX) $(CXXFLAGS)
LDFLAGS=
LDFLAGS+=-L$(OutDir) -Wl,--subsystem,console
LIBS+=-lkernel32 -luser32 -lgdi32 -lwinspool -lcomdlg32 -ladvapi32 -lshell32 -lole32 -loleaut32 -luuid -lodbc32 -lodbccp32 -lWinmm -lShell32 hook/hook.a
else
ifeq "$(CFG)"  "Release"
CFLAGS+=-D_CONSOLE -I include -DUSE_STDIO -isystem $(WMFSDK)/include -D_MBCS -g -W -Wno-ctor-dtor-privacy -O2 -finline-functions -fomit-frame-pointer -DWIN32 -DNDEBUG
LD=$(CXX) $(CXXFLAGS)
LDFLAGS=
LDFLAGS+=-Llib -L$(OutDir) -Wl,--subsystem,console
LIBS+=-lkernel32 -luser32 -lgdi32 -lwinspool -lcomdlg32 -ladvapi32 -lshell32 -lole32 -loleaut32 -luuid -lodbc32 -lodbccp32 -lWinmm -lShell32 hook/hook.a
endif
endif

ifndef TARGET
TARGET=CamIt.exe
endif

.PHONY: all
all: $(TARGET)

%.o: %.c
	$(CC) $(CFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cc
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cpp
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.o: %.cxx
	$(CXX) $(CXXFLAGS) $(CPPFLAGS) -o $@ -c $<

%.res: %.rc
	$(RC) $(CPPFLAGS) -o $@ -i $<

ifeq "$(CFG)"  "Debug"
CFLAGS+=
else
ifeq "$(CFG)"  "Release"
CFLAGS+=
endif
endif
SOURCE_FILES= \
	src/accel.cpp \
	src/ArgsInfo.cpp \
	src/BitMap.cpp \
	src/CamIt.cpp \
	src/Console.cpp \
	src/Format.cpp \
	src/FrameGrabber.cpp \
	src/FrameWnd.cpp \
	src/getopt.cpp \
	src/Grabber.cpp \
	src/main.cpp \
	src/SavedBmp.cpp \
	src/SelWnd.cpp \
	src/SoundBuffer.cpp \
	src/stdafx.cpp \
	src/WaveRecorder.cpp \
	src/WindowFinder.cpp \
	src/WMFile.cpp \
	src/WMProfiles.cpp \
	src/initguid.cpp \
	src/wmvcore.cpp

HEADER_FILES= \
	include/accel.h \
	include/ArgsInfo.h \
	include/BitMap.h \
	include/CamIt.h \
	include/CComPtr.h \
	include/ComError.h \
	include/compiler.h \
	include/Console.h \
	include/CriticalSection.h \
	include/Format.h \
	include/FrameGrabber.h \
	include/FrameWnd.h \
	include/getopt.h \
	include/Grabber.h \
	include/IUnknownImpl.h \
	include/MutexLock.h \
	res/resource.h \
	include/SafeQueue.h \
	include/SavedBmp.h \
	include/SelWnd.h \
	include/SmrtHandle.h \
	include/SoundBuffer.h \
	include/stdafx.h \
	include/tstring.h \
	include/util.h \
	include/WaveRecorder.h \
	include/WindowFinder.h \
	include/WMFile.h \
	include/WMMediaTypePtr.h \
	include/WMProfiles.h

ifeq "$(CFG)"  "Debug"
else
ifeq "$(CFG)"  "Release"
endif
endif
RESOURCE_FILES= \
	res/camit.rc \
	res/crosshair.ico \
	res/findere.bmp \
	res/finderf.bmp \
	res/notpad.bmp \
	res/searchw.cur

SRCS=$(SOURCE_FILES) $(HEADER_FILES) $(RESOURCE_FILES) 

OBJS=$(patsubst %.rc,%.res,$(patsubst %.cxx,%.o,$(patsubst %.cpp,%.o,$(patsubst %.cc,%.o,$(patsubst %.c,%.o,$(filter %.c %.cc %.cpp %.cxx %.rc,$(SRCS)))))))

$(TARGET): $(OBJS)
	$(LD) $(LDFLAGS) -o $@ $(OBJS) $(LIBS)

.PHONY: clean
clean:
	-rm -f $(OBJS) $(TARGET) CamIt.dep

.PHONY: depends
depends:
	-$(CXX) $(CXXFLAGS) $(CPPFLAGS) -MM $(filter %.c %.cc %.cpp %.cxx,$(SRCS)) > CamIt.dep

-include CamIt.dep

