//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_H
#define CAMIT_H

#include "FrameGrabber.h"
#include "WaveRecorder.h"
#include "WMFile.h"
#include "ArgsInfo.h"
#include "Console.h"

namespace camit {

//------------------------------------------------------------------------------
// Main application class
//------------------------------------------------------------------------------
class CamIt
{
public:
    // constructor
    CamIt();

    // destructor
    ~CamIt();

    // set to window
    void                setRecordedWindow(HWND hwnd);

    // set to full-screen recording
    void                setFullScreen();

    // let user select recorded area
    void                chooseRecordedArea(long width = -1, long height = -1);

    // let user select a recorded window
    bool                chooseRecordedWindow();

    // start recording
    bool                record(const ArgsInfo& args);

protected:
    bool                writesSamples(bool bFinal);
    void                registerHotKeys(const ArgsInfo& args);

private:

    static BOOL CALLBACK enumWindowsProc(HWND hwnd, LPARAM lParam);


    bool                soundEnabled_;
    long                desktopWidth_;
    long                desktopHeight_;
    RECT                recordedArea_;
    HWND                recordedWindow_;
    HWND                titleBarWindow_;    // window with title bar for place buttons

    SmrtHotKey          hotkeyPause_;       // global hotkey (pause)
    SmrtHotKey          hotkeyStop_;        // global hotkey (stop)
    SmrtHotKey          hotkeyResume_;      // global hotkey (resume)

    UINT                windowMsgPause_;    // window message sent when Pause button pressed  
    SmrtAtomHandle      msgIdPause_;        // WPARAM sent when Pause button pressed

    UINT                windowMsgStop_;     // window message sent when Stop button pressed  
    SmrtAtomHandle      msgIdStop_;         // WPARAM sent when Stop button pressed

    UINT                windowMsgResume_;   // window message sent when Resume button pressed  
    SmrtAtomHandle      msgIdResume_;       // WPARAM sent when Resume button pressed

    Console             console_;           // console for command I/O

    FrameQueue          frameQueue_;        // queue for captured frames
    SoundQueue          soundQueue_;        // queue for recorded samples
    FrameGrabber        frameGrabber_;      // frame grabber
    WaveRecorder        waveRecorder_;      // wave recorder

    WMFile              wmFile_;            // windows media file

    StampedSoundBuffer dummySoundBuffer_; // sound buffer used when sound disabled
};

} // namespace camit

#endif  // CAMIT_H

