//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_COM_ERROR_H
#define CAMIT_COM_ERROR_H

#include <stdexcept>
#include <sstream>
#include <iomanip>

namespace camit {

class ComError : public std::runtime_error
{
public:
    ComError(HRESULT hr) : 
      std::runtime_error(errorMessage(hr)),
      hr_(hr)
    {
    }

    HRESULT             hr_;

private:
    static std::string  errorMessage(HRESULT hr)
    {
        LPSTR msg = NULL;
        DWORD len = ::FormatMessageA(
            FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_FROM_SYSTEM,
            NULL,
            hr,
            MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
            msg,
            0,
            NULL);

        if (len) 
        {
            std::string str(msg);
            LocalFree(msg);

            if (len > 1 && str[len - 1] == '\n')
            {
                str.resize(--len);
            }

            if (len > 1 && str[len - 1] == '\r')
            {
                str.resize(--len);
            }

            return str;
        } 
        else 
        {
            std::ostringstream oss;
            oss << "Unknown error 0x" 
                << std::hex << std::setfill('0') << std::uppercase
                << std::setw(8)
                << hr;
            return oss.str();
        }
    }
};

} // namespace camit

#endif // CAMIT_COM_ERROR_H
