//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_CONSOLE_H
#define CAMIT_CONSOLE_H

#include "SmrtHandle.h"
#include <list>
#include <string>

namespace camit {

// -----------------------------------------------------------------------------
//  Class to poll the standard input console and parse the interactive commands
// -----------------------------------------------------------------------------
class Console
{
public:
    // constructor
    Console();

    // destructor
    ~Console();

    // register command
    void                registerCommand(const std::string& cmd, int id, UINT hotkey);

    // start capture thread
    void                start();  // thread msg is sent to

    // pause/stop capture thread
    void                stop();

protected:

    static unsigned int WINAPI  threadProcStub(LPVOID);
    unsigned int        threadProc();

    bool                parseCommand(char c);

private:

    struct Command 
    {
        DWORD       threadId;
        std::string cmd;
        int         id;
        UINT        hotkey;
    };

    typedef std::list<Command>  Commands;

    Commands            commands_;
    SmrtWin32Handle     thread_;
    char*               buffer_;
    size_t              usedBuffer_;
    size_t              maxCmdLength_;
};

} // namespace camit

#endif  // CAMIT_CONSOLE_H
