//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_FRAME_GRABBER_H
#define CAMIT_FRAME_GRABBER_H

#include "Grabber.h"
#include "SmrtHandle.h"
#include "SafeQueue.h"
#include "Format.h"
#include "BitMap.h"
#include <utility>

namespace camit {

//------------------------------------------------------------------------------
// A captured screen, stamped with the recording time
//------------------------------------------------------------------------------
typedef std::pair<DWORD, CComPtr<IBitMap> >  StampedFrame;

//------------------------------------------------------------------------------
// FIFO of captured screenshots
//------------------------------------------------------------------------------
typedef SafeQueue<StampedFrame> FrameQueue;

//------------------------------------------------------------------------------
// Class responsible for taking sequences of screenshots
//------------------------------------------------------------------------------
class FrameGrabber
{
public:
    // constructor
    FrameGrabber(FrameQueue& q);

    // destructor
    ~FrameGrabber();

    // start capture thread
    void                start(const RECT&   rc,
                              HWND          hwnd,
                              const Format& fmt, 
                              HANDLE        hFrameAvailable, 
                              DWORD         startTimeMs = 0);

    // pause/stop capture thread
    void                stop();

    // resume
    void                resume();

    // adjust FPS
    int                 decreaseFps();
    int                 increaseFps();

protected:
    static unsigned int WINAPI  threadProcStub(LPVOID);
    unsigned int                threadProc();

    bool                isWindowVisible() const;

private:
    FrameQueue&         frameQueue_;
    RECT                recordedArea_;
    HWND                recordedWindow_;
    HANDLE              frameAvailableEvent_;
    int                 framesPerSecond_;
    int                 framesPerSecondMax_;
    SmrtWin32Handle     thread_;
    SmrtWin32Handle     stopEvent_;
    DWORD               startOffset_;
    DWORD               startTime_;
    DWORD               resumeTime_;
};

} // namespace camit

#endif // CAMIT_FRAME_GRABBER_H
