//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_GRABBER_H
#define CAMIT_GRABBER_H

#include "BitMap.h"
#include "SmrtHandle.h"
#include <list>

namespace camit {

//------------------------------------------------------------------------------
// Class used to take screenshots
//------------------------------------------------------------------------------
class Grabber
{
public:

    enum Shape {
        CH_NONE,
        CH_CIRCLE,
        CH_ELLIPSE,
        CH_SQUARE,
        CH_RECTANGLE
    };

    // constructor
    Grabber(const RECT& rc = RECT());

    // destructor
    ~Grabber();

    // set grabbed rectangle
    void                setScreenArea(const RECT& rc);

    // take a shot
    HRESULT             captureScreen(IBitMap** ppIBitMap) const;

    size_t              getPoolSize() const;

protected:

    HRESULT             bitmapToDIB(HBITMAP hbitmap, IBitMap** ppIBitMap) const;
    HCURSOR             fetchCursorHandle() const;
    void                hiliteCursor(HDC hdc, int xoffset, int yoffset) const;

    HRESULT             newBitMap(LONG width, LONG height, WORD bits, BitMap** ppBitMap) const;

private:
    // pool of allocated bitmaps
    typedef std::list<BitMap*> BitMapPool;
    mutable BitMapPool  bitMaps_;           // list of allocated bitmaps
    mutable int         spareBitmaps_;      // number of spare bitmaps to keep in list

    bool                captureCursor_;     // if cursor is captured
    HCURSOR             defaultCursor_;
    HCURSOR             customCursor_;

    // forced color depth (0 = not forced)
    WORD                colorDepth_;

    // captured region
    long                left_;
    long                top_;
    long                width_;
    long                height_;

    // cached memory DC
    mutable SmrtDcRelease    desktopDc_;
    mutable SmrtBitMapHandle bitmapDc_;
    mutable SmrtDcHandle     memoryDc_;

    // cached cursor handle
    SmrtWindowsHookHandle cursorHook_;

    // cursor hiliting
    int                   hiliteSize_;
    COLORREF              hiliteColor_;
    Shape                 hiliteShape_;

};

} // namespace camit

#endif // CAMIT_GRABBER_H
