//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_MUTEX_LOCK
#define CAMIT_MUTEX_LOCK

namespace camit {

//------------------------------------------------------------------------------
// Class encapsulating acquisition and releasing of mutexes
//------------------------------------------------------------------------------
class MutexLock
{
public:
    MutexLock(HANDLE hMutex) : 
        mutex_(hMutex)
    {
        WaitForSingleObject(mutex_, INFINITE);
    }

    ~MutexLock()
    {
        ReleaseMutex(mutex_);
    }

private:
    HANDLE mutex_;
};

} // namespace camit

#endif  // CAMIT_MUTEX_LOCK
