//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_SAVED_BITMAP_H
#define CAMIT_SAVED_BITMAP_H

namespace camit {

//------------------------------------------------------------------------------
// Helper class encapsulating a temporary saved screen area
//------------------------------------------------------------------------------
class SavedBmp
{
public:
    SavedBmp();
    ~SavedBmp();

    void                save(HDC hdc, HDC hdcbits, int x, int y, int dx, int dy);
    void                restore(HDC hdc, HDC hdcbits);
    void                release();

private:

    HBITMAP             bitmap_;
    int                 x_;
    int                 y_;
    int                 width_;
    int                 height_;
};

} // namespace camit

#endif // CAMIT_SAVED_BITMAP_H
