//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_SEL_WND_H
#define CAMIT_SEL_WND_H

#include "SavedBmp.h"
#include "SmrtHandle.h"

namespace camit {

//------------------------------------------------------------------------------
// Window for selecting the recorded screen region
//------------------------------------------------------------------------------
class SelWnd
{
public:
    // selection modes
    enum Mode { RM_FIXED, RM_VARIABLE };

    // constructor
    SelWnd(Mode mode, int width = -1, int height = -1, int border = 2);

    // run window
    bool                run();

    // obtain selected region
    const RECT&         getRegion() const { return recordedArea_; }

    // get screen size
    long                getScreenSizeX() const { return screenSizeX_; }
    long                getScreenSizeY() const { return screenSizeY_; }

protected:
    ATOM                registerWndClass();
    void                create();
    int                 initFixedWnd();
    void                drawSelectionFrame(HDC hdc, BOOL fDraw, LPRECT lprClip);
    RECT                frameWindow();
    LRESULT             wndProc(HWND, UINT, WPARAM, LPARAM);
    static LRESULT CALLBACK wndProcStub(HWND, UINT, WPARAM, LPARAM);

private:

    HINSTANCE           moduleHandle_;
    SmrtWndHandle       windowHandle_;
    SavedBmp            savedBitmap_;
    Mode                regionMode_;            // region definition mode
    bool                selectingRegion_;
    RECT                fixedArea_;
    RECT                recordedArea_;          // region selected for recording
    RECT                prevRecordedArea_;      // previous region
    RECT                offset_; 
    POINT               startPoint_;            // starting point of selected region
    int                 screenSizeX_; 
    int                 screenSizeY_;
    int                 borderSize_;
};

} // namespace camit

#endif  // CAMIT_SEL_WND_H
