//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_WMFILE_H
#define CAMIT_WMFILE_H
#include "BitMap.h"
#include "Format.h"
#include "SoundBuffer.h"
#include "tstring.h"

namespace camit {

//------------------------------------------------------------------------------
// Class for creating and managing WMV (Windows Media) files
//------------------------------------------------------------------------------
class WMFile
{
public:

    // constructor
    WMFile();

    // destructor
    ~WMFile();

    // test alignment
    bool                testAlignment(Format& fmt) const;

    // initialize
    bool                open(TCHAR*  strFileName, Format& fmt, bool bDummySound);

    // write a video sample
    bool                writeVideoSample(INSSBuffer* pIBmp, DWORD timeMs);

    // write an audio sample
    bool                writeAudioSample(INSSBuffer* pISample, DWORD timeMs);

    // next frame is key
    void                key();

    // next frame is resumed after discontinuity
    void                discontinuity();

    // finish up
    void                close();

    // dump profiles to stdout
    bool                dumpSystemProfiles() const;

private:

    // get a configured video stream configuration
    HRESULT             createVideoStreamConfig(IWMProfileManager*  pIMgr,
                                WORD                dwStreamNumber,
                                Format&             fmt,
                                IWMStreamConfig**   ppIWMStreamConfig) const;

    // get a configured audio stream configuration
    HRESULT             createAudioStreamConfig(IWMProfileManager*  pIMgr,
                                WORD                dwStreamNumber,
                                Format&             fmt,
                                IWMStreamConfig**   ppIWMStreamConfig) const;

    // configure video input stream
    void                configureVideoInput(Format&                 fmt, 
                                IWMWriter*              pIWriter,
                                DWORD                   dwVideoInput,
                                IWMInputMediaProps*     pIInputMediaProps) const;

    // configure audio input stream
    void                configureAudioInput(Format&                 fmt, 
                                IWMWriter*              pIWriter,
                                DWORD                   dwAudioInput,
                                IWMInputMediaProps*     pIInputMediaProps) const;


    // set clip header info
    void                setHeaderInfo(WCHAR* name, const WCHAR* value);

    // convert bitmap subtype to GUID
    GUID                getBitmapSubtype(const BITMAPINFOHEADER* pbmiHeader) const;

private:
    class StatusCallback;

    bool                verbose_;
    bool                discontinuity_;
    LONG                prevKeyFrameMs_;
    DWORD               keyFrameIntervalMs_;
    tstring             fileName_;
    CComPtr<IWMWriter>  pIWriter_;
    CComPtr<IWMWriterAdvanced> pIWriterAdvanced_;
    DWORD               videoInput_;
    DWORD               audioInput_;
    bool                dummySound_;
    CComPtr<INSSBuffer> dummySoundBuffer_;
};

} // namespace camit

#endif // CAMIT_WMFILE_H
