//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_WM_PROFILES_H
#define CAMIT_WM_PROFILES_H

#include <MMSystem.h>

namespace camit {

//------------------------------------------------------------------------------
// Helper class to extract various information from Windows Media profiles
//------------------------------------------------------------------------------
class WMProfiles
{
public:
    WMProfiles();

    WMProfiles(IWMProfileManager* pIMgr);

    ~WMProfiles();

    // get an empty stream configuration using a given codec for compression
    void                getVideoCodec(FOURCC fourCc, IWMStreamConfig** ppIWMStreamConfig) const;

    // get a suitable audio compressor
    void                getAudioCodec(const WAVEFORMATEX& wfe, REFGUID guidCodec, IWMStreamConfig** ppIWMStreamConfig) const;

    // diagnostic functions
    void                dumpSystemProfiles() const;
    void                dumpProfile(IWMProfile* pIProfile) const;
    void                dumpCodecs(REFGUID guidType) const;
    void                dumpCodecInfo(IWMStreamConfig* pICfg) const;
    void                dumpMediaType(WM_MEDIA_TYPE* mt) const;
    void                dumpVIH(WMVIDEOINFOHEADER* vih) const;

private:
    
    CComPtr<IWMProfileManager>  profileMgr_;
};

} // namespace camit

#endif // CAMIT_WM_PROFILES_H

