//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_ACCEL_H
#define CAMIT_ACCEL_H

namespace camit {

//------------------------------------------------------------------------------
// Set the graphics card acceleration level (same as the "troubleshooting" slider
// in the Display Control Panel > Advanced > Troubleshooting.
//------------------------------------------------------------------------------
enum AccelerationLevel
{
    ACELLERATION_FULL   = 0x00,
    ACELLERATION_HIGH   = 0x01,
    ACCELEARTION_MEDIUM = 0x02,
    ACELLERATION_LOW    = 0x03,
    ACELLERATION_BASIC  = 0x04,
    ACCELERATION_NONE   = 0x05,
    ACCELERATION_INVALID= 0x0ff
};

bool setAccelerationLevel(AccelerationLevel level);

bool getAccelerationLevel(AccelerationLevel& level);

} // namespace camit

#endif  // CAMIT_ACCEL_H
