//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_COMPILER_H
#define CAMIT_COMPILER_H

#if defined(_MSC_VER)

# define CAMIT_NOVTABLE __declspec(novtable)

typedef __int8            int8_t;
typedef unsigned __int8   uint8_t;
typedef short             int16_t;
typedef unsigned short    uint16_t;
typedef long              int32_t;
typedef unsigned long     uint32_t;
typedef __int64           int64_t;
typedef unsigned __int64  uint64_t;

#define INT8_C(value)     value##i8
#define INT16_C(value)    value##i16
#define INT32_C(value)    value##i32
#define INT64_C(value)    value##i64
#define UINT8_C(value)    value##ui8
#define UINT16_C(value)   value##ui16
#define UINT32_C(value)   value##ui32
#define UINT64_C(value)   value##ui64
#define INTMAX_C(value)   value##i64
#define UINTMAX_C(value)  value##ui64

# if _MSC_VER < 1300

#   define CAMIT_TYPENAME

# else // _MSC_VER < 1300

#   define CAMIT_TYPENAME typename

# endif // _MSC_VER < 1300

#elif defined(__GNUC__)

typedef char              int8_t;
typedef unsigned char     uint8_t;
typedef short             int16_t;
typedef unsigned short    uint16_t;
typedef long              int32_t;
typedef unsigned long     uint32_t;
typedef long long         int64_t;
typedef unsigned long long uint64_t;

#define INT8_C(value)     static_cast<char>(value##L)
#define INT16_C(value)    static_cast<short>(value##L)
#define INT32_C(value)    value##L
#define INT64_C(value)    value##LL
#define UINT8_C(value)    static_cast<unsigned char>(value##U)
#define UINT16_C(value)   static_cast<unsigned short>(value##U)
#define UINT32_C(value)   value##U
#define UINT64_C(value)   value##ULL
#define INTMAX_C(value)   value##LL
#define UINTMAX_C(value)  value##ULL

#define CAMIT_NOVTABLE
#define CAMIT_TYPENAME typename

#endif

// various macro definitions
#ifndef EXTERN_GUID
#define EXTERN_GUID DEFINE_GUID
#endif

#endif // CAMIT_COMPILER_H
