//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#ifndef CAMIT_GETOPT_H
#define CAMIT_GETOPT_H

namespace getopt {

//------------------------------------------------------------------------------
// Structure definition for getopt_long
//
//  The meanings of the different fields are:
//
//  name
//    is the name of the long option.
//
//  has_arg
//    no_argument (or 0) if the option does not take an argument,
//    required_argument (or 1) if the option requires an argument, or
//    optional_argument (or 2) if the option takes an optional argument.
//
//  flag
//    specifies how results are returned for a long option.  If flag is
//    NULL, then getopt_long() returns val.  (For example, the calling
//    program may set val to the equivalent short option character.)
//    Otherwise, getopt_long() returns 0, and flag points to a variable
//    which is set to val if the option is found, but left unchanged if
//    the option is not found.
//
//  val
//    is the value to return, or to load into the variable pointed to by
//    flag.
//
//  The last element of the array has to be filled with zeroes.
//
//------------------------------------------------------------------------------
struct Option 
{
    const _TCHAR* name;
    int           has_arg;
    int*          flag;
    int           val;
};

// Symbolic constants for getopt_long
#define no_argument 0		    // the option does not take an argument
#define required_argument 1	    // the option requires an argument
#define optional_argument 2	    // the option takes an optional argument

// Global variables for getopt_long
extern int       opterr;            // if error message should be printed
extern int       optind;            // index into parent argv vector
extern int       optopt;            // character checked for validity
extern int       optreset;          // reset getopt
extern _TCHAR*   optarg;            // argument associated with option

// Function prototype for getopt_long
int getopt_long(int argc, _TCHAR * const * argv, const _TCHAR* optstring, const Option* longopts, int* longindex);

} // namespace getopt

#endif // CAMIT_GETOPT_H

