//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#include "stdafx.h"
#include "FrameWnd.h"

namespace camit {

//------------------------------------------------------------------------------
FrameWnd::FrameWnd(const RECT& rc, 
                   int border /* = 8 */, 
                   int edge /* = 24 */, 
                   COLORREF clr1 /* = RGB(255, 255, 180) */,
                   COLORREF clr2 /* = RGB(0, 255, 80) */) :
    m_hInst(NULL),
    m_hWnd(NULL),
    m_rc(rc),
    m_nBorder(border),
    m_nEdge(edge),
    m_clr1(clr1),
    m_clr2(clr2),
    m_bState(false)
{
    // get module instance handle
    m_hInst = GetModuleHandle(NULL);

    // determine screen dimensions
    SmrtDcRelease hDc(NULL, GetDC(NULL));
    m_screenSizeX = GetDeviceCaps(hDc, HORZRES);
    m_screenSizeY = GetDeviceCaps(hDc, VERTRES);

    // register our windows class
    registerWndClass();
    create();
}

//------------------------------------------------------------------------------
ATOM FrameWnd::registerWndClass()
{
    // register the window class
    WNDCLASSEX wcex;
    ZeroMemory(&wcex, sizeof(wcex));
    wcex.cbSize = sizeof(wcex);
    wcex.style = 0;
    wcex.lpfnWndProc = DefWindowProc;
    wcex.cbClsExtra = 0;
    wcex.cbWndExtra = 0;
    wcex.hInstance = m_hInst;
    wcex.hIcon = NULL;
    wcex.hCursor = NULL;
    wcex.hbrBackground = NULL;
    wcex.lpszMenuName = NULL;
    wcex.lpszClassName = _T("CamItFrameWnd");
    wcex.hIconSm = NULL;
    return RegisterClassEx(&wcex);
}

//------------------------------------------------------------------------------
void FrameWnd::create()
{
    m_hWnd.reset(CreateWindowEx(WS_EX_TOPMOST | WS_EX_TOOLWINDOW, 
                _T("CamItFrameWnd"), 
                _T(""),  
                WS_POPUP, 
                m_rc.left,
                m_rc.top,
                m_rc.right - m_rc.left, 
                m_rc.bottom - m_rc.top,
                NULL, 
                NULL, 
                m_hInst, 
                reinterpret_cast<LPVOID>(this)));

    configureWindowRgn();
    ShowWindow(m_hWnd, SW_MAXIMIZE);
}

// ---------------------------------------------------------------------------
//  Set the Window Region for transparancy outside the mask region
// ---------------------------------------------------------------------------
void FrameWnd::configureWindowRgn()
{
    // syntactic sugar...
    LONG& x0 = m_rc.left;
    LONG& y0 = m_rc.top;
    LONG  x1 = m_rc.right;
    LONG  y1 = m_rc.bottom;

    // create regions
    SmrtRgnHandle rgnO(CreateRectRgn(x0-m_nBorder,          y0-m_nBorder,         x1+m_nBorder,         y1+m_nBorder   ));
    SmrtRgnHandle rgnI(CreateRectRgn(x0,                    y0,                   x1,                   y1            ));
    SmrtRgnHandle rgnH(CreateRectRgn(x0-m_nBorder,          y0-m_nBorder+m_nEdge, x1+m_nBorder,         y1+m_nBorder-m_nEdge));
    SmrtRgnHandle rgnV(CreateRectRgn(x0-m_nBorder+m_nEdge,  y0-m_nBorder,         x1+m_nBorder-m_nEdge, y1+m_nBorder     ));

    // create "photographic edges" by combining the above regions
    CombineRgn(rgnO, rgnO, rgnI, RGN_DIFF);
    CombineRgn(rgnO, rgnO, rgnH, RGN_DIFF);
    CombineRgn(rgnO, rgnO, rgnV, RGN_DIFF);

    SetWindowRgn(m_hWnd, rgnO.release(), TRUE);
    MoveWindow(m_hWnd, m_rc.left, m_rc.top, m_rc.right - m_rc.left, m_rc.bottom - m_rc.top, FALSE);
}

//------------------------------------------------------------------------------
void FrameWnd::flash(const RECT& rc)
{
    if (!EqualRect(&m_rc, &rc)) 
    {
        CopyRect(&m_rc, &rc);
        create();
    }

    paintBorder(m_bState ? m_clr1 : m_clr2);
    m_bState = !m_bState;
}

//------------------------------------------------------------------------------
void FrameWnd::show()
{
    if (!IsWindowVisible(m_hWnd)) 
    {
        ShowWindow(m_hWnd, SW_SHOW);
    }
}

//------------------------------------------------------------------------------
void FrameWnd::hide()
{
    if (IsWindowVisible(m_hWnd)) 
    {
        ShowWindow(m_hWnd, SW_HIDE);
    }
}

//------------------------------------------------------------------------------
void FrameWnd::paintBorder(COLORREF colorval)
{
    // syntactic sugar...
    LONG& x0 = m_rc.left;
    LONG& y0 = m_rc.top;
    LONG& x1 = m_rc.right;
    LONG& y1 = m_rc.bottom;

    SmrtDcRelease    hDc(m_hWnd, GetDC(m_hWnd));

    SmrtBrushHandle newbrush(CreateSolidBrush(colorval));
    SmrtGdiSelect   oldbrush(hDc, SelectObject(hDc, newbrush));

    SmrtPenHandle   newpen(CreatePen(PS_SOLID, 1, colorval));
    SmrtGdiSelect   oldpen(hDc, SelectObject(hDc, newpen));

    Rectangle(hDc, x0-m_nBorder, y0-m_nBorder, x1+m_nBorder, y1+m_nBorder);
}

} // namespace camit
