//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#include "stdafx.h"
#include "SoundBuffer.h"

namespace camit {

// {41E9F321-0597-4400-B2F6-09EB11C2DCD3}
const IID IID_ISoundBuffer = { 0x41e9f321, 0x597, 0x4400,  { 0xb2, 0xf6, 0x9, 0xeb, 0x11, 0xc2, 0xdc, 0xd3 } };

//------------------------------------------------------------------------------
SoundBuffer::SoundBuffer(size_t size) :
    buffer_(NULL)
{
    buffer_  = new BYTE[size];

    ZeroMemory(&waveHeader_, sizeof(WAVEHDR));
    waveHeader_.lpData          = reinterpret_cast<LPSTR>(buffer_);
    waveHeader_.dwBufferLength  = static_cast<DWORD>(size);
}

//------------------------------------------------------------------------------
SoundBuffer::~SoundBuffer()
{
    delete [] buffer_;
}

//------------------------------------------------------------------------------
// Override this to say what interfaces we support and where
//------------------------------------------------------------------------------
STDMETHODIMP SoundBuffer::NonDelegatingQueryInterface(REFIID riid, void ** ppv)
{
    if (riid == IID_INSSBuffer)
    {
        *ppv = static_cast<INSSBuffer*>(this);
        static_cast<INSSBuffer*>(this)->AddRef();
        return S_OK;
    }
    else if (riid == IID_ISoundBuffer)
    {
        *ppv = static_cast<ISoundBuffer*>(this);
        static_cast<ISoundBuffer*>(this)->AddRef();
        return S_OK;
    } 
    else 
    {
        return IUnknownImpl::NonDelegatingQueryInterface(riid, ppv);
    }
}

//------------------------------------------------------------------------------
STDMETHODIMP SoundBuffer::GetPreparedHeader(HWAVEIN hInputDev, LPWAVEHDR* ppwhdr)
{
    if (ppwhdr == NULL) return E_POINTER;
    if (waveHeader_.dwFlags & WHDR_PREPARED) return E_FAIL;

    // prepare the wave header
    MMRESULT res = waveInPrepareHeader(hInputDev, &waveHeader_, sizeof(WAVEHDR));

    if (res != MMSYSERR_NOERROR) 
    {
        switch (res)
        {
        case MMSYSERR_INVALHANDLE:  return E_INVALIDARG;
        case MMSYSERR_NODRIVER:     return E_FAIL;
        case MMSYSERR_NOMEM:        return E_OUTOFMEMORY;
        default:                    return E_FAIL;
        }
    }

    *ppwhdr = &waveHeader_;

    // store a reference to this interface in the header's user data
    waveHeader_.dwUser = reinterpret_cast<DWORD_PTR>(static_cast<ISoundBuffer*>(this));

    // need to AddRef() because a reference is now stored in the header
    AddRef();

    return S_OK;
}

//------------------------------------------------------------------------------
STDMETHODIMP SoundBuffer::UnprepareHeader(HWAVEIN hInputDev)
{
    MMRESULT res = waveInUnprepareHeader(hInputDev, &waveHeader_, sizeof(WAVEHDR));

    if (res != MMSYSERR_NOERROR) 
    {
        switch (res) {
      case MMSYSERR_INVALHANDLE:  return E_INVALIDARG;
      case MMSYSERR_NODRIVER:     return E_FAIL;
      case MMSYSERR_NOMEM:        return E_OUTOFMEMORY;
      case WAVERR_STILLPLAYING:   return E_FAIL;
      default:                    return E_FAIL;
        }
    }

    // remove interface reference stored in the header's user data
    waveHeader_.dwUser = 0;
    Release();

    return S_OK;
}

//------------------------------------------------------------------------------
STDMETHODIMP SoundBuffer::GetLength(DWORD* pdwLength)
{
    if (pdwLength == NULL) return E_POINTER;
    *pdwLength = waveHeader_.dwBytesRecorded;
    return S_OK;
}

//------------------------------------------------------------------------------
STDMETHODIMP SoundBuffer::SetLength(DWORD dwLength)
{
    return E_NOTIMPL;
}

//------------------------------------------------------------------------------
STDMETHODIMP SoundBuffer::GetMaxLength(DWORD* pdwLength)
{
    if (pdwLength == NULL) return E_POINTER;
    *pdwLength = waveHeader_.dwBufferLength;
    return S_OK;
}

//------------------------------------------------------------------------------
STDMETHODIMP SoundBuffer::GetBuffer(BYTE** ppdwBuffer)
{
    if (ppdwBuffer == NULL) return E_POINTER;
    *ppdwBuffer = reinterpret_cast<BYTE*>(waveHeader_.lpData);
    return S_OK;
}

//------------------------------------------------------------------------------
STDMETHODIMP SoundBuffer::GetBufferAndLength(BYTE** ppdwBuffer, DWORD* pdwLength)
{
    if (ppdwBuffer == NULL || pdwLength == NULL) return E_POINTER;
    *pdwLength = waveHeader_.dwBytesRecorded;
    *ppdwBuffer = reinterpret_cast<BYTE*>(waveHeader_.lpData);
    return S_OK;
}

} // namespace camit
