//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------
#include "stdafx.h"
#include "accel.h"
#include <Winreg.h>
#include "SmrtHandle.h" 

namespace camit {

//------------------------------------------------------------------------------
bool setAccelerationLevel(AccelerationLevel level) 
{
    OSVERSIONINFO osv;
    ZeroMemory(&osv, sizeof(osv));
    osv.dwOSVersionInfoSize = sizeof(osv);
    if (!GetVersionEx(&osv)) return false;

    if (osv.dwPlatformId != VER_PLATFORM_WIN32_NT) 
    return false;

    // find active display device
    SmrtRegHandle hKeyVideo;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("HARDWARE\\DEVICEMAP\\VIDEO"), 0, KEY_QUERY_VALUE, &hKeyVideo) != ERROR_SUCCESS) return false;

    // read path
    TCHAR strDev0[MAX_PATH];
    DWORD dw = MAX_PATH;
    if (RegQueryValueEx(hKeyVideo, _T("\\Device\\Video0"), NULL, NULL, (LPBYTE)strDev0, &dw) != ERROR_SUCCESS) return false;

    // check the leading machine hive
    TCHAR strMachine[] = _T("\\Registry\\Machine\\");
    if (_tcsnicmp(strDev0, strMachine, _tcslen(strMachine)) != 0) return false;

    // open device key
    SmrtRegHandle hKeyDevice0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, strDev0 + _tcslen(strMachine), 0, KEY_SET_VALUE, &hKeyDevice0) != ERROR_SUCCESS) return false;

    // store new acceleration
    DWORD dwLevel = level;

    if (RegSetValueEx(hKeyDevice0, _T("Acceleration.Level"), 0, REG_DWORD, (LPBYTE)&dwLevel, sizeof(DWORD)) != ERROR_SUCCESS) return false;
    if (RegFlushKey(hKeyDevice0) != ERROR_SUCCESS) return false;

    // and apply
    if (ChangeDisplaySettings(NULL, CDS_UPDATEREGISTRY) != DISP_CHANGE_SUCCESSFUL) return false;

    return true;
}

//------------------------------------------------------------------------------
bool getAccelerationLevel(AccelerationLevel& level) 
{
    OSVERSIONINFO osv;
    ZeroMemory(&osv, sizeof(osv));
    osv.dwOSVersionInfoSize = sizeof(osv);
    if (!GetVersionEx(&osv)) return false;

    if (osv.dwPlatformId != VER_PLATFORM_WIN32_NT) 
    return false;

    // find active display device
    SmrtRegHandle hKeyVideo;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, _T("HARDWARE\\DEVICEMAP\\VIDEO"), 0, KEY_QUERY_VALUE, &hKeyVideo) != ERROR_SUCCESS) return false;

    // read path
    TCHAR strDev0[MAX_PATH];
    DWORD dw = MAX_PATH;
    if (RegQueryValueEx(hKeyVideo, _T("\\Device\\Video0"), NULL, NULL, (LPBYTE)strDev0, &dw) != ERROR_SUCCESS) return false;

    // check the leading machine hive
    TCHAR strMachine[] = _T("\\Registry\\Machine\\");
    if (_tcsnicmp(strDev0, strMachine, _tcslen(strMachine)) != 0) return false;

    // open device key
    SmrtRegHandle hKeyDevice0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE, strDev0 + _tcslen(strMachine), 0, KEY_QUERY_VALUE, &hKeyDevice0) != ERROR_SUCCESS) return false;

    // query value
    DWORD dwLevel;
    DWORD dwSize = sizeof(DWORD);
    if (RegQueryValueEx(hKeyDevice0, _T("Acceleration.Level"), NULL, NULL, (LPBYTE)&dwLevel, &dwSize) != ERROR_SUCCESS) 
    {
        level = ACELLERATION_FULL;
    }
    else 
    {
        level = (AccelerationLevel)dwLevel;
    }
    return true;
}

} // namespace camit

