//------------------------------------------------------------------------------
//
// Copyright (C) 2002 - 2003  Daniel Gehriger <gehriger@linkcad.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//------------------------------------------------------------------------------

// Dynamically loads functions from wmvcore.dll (needed when compiling 
// using GCC)

#include <stdafx.h>

typedef HRESULT (STDMETHODCALLTYPE *PFN_WMIsContentProtected)( const WCHAR *pwszFileName, BOOL *pfIsProtected );
typedef HRESULT (STDMETHODCALLTYPE *PFN_WMCreateCertificate)( IUnknown** pUnkCert );
typedef HRESULT (STDMETHODCALLTYPE *PFN_WMCreateWriter)( IUnknown* pUnkCert, IWMWriter **ppWriter );
typedef HRESULT (STDMETHODCALLTYPE *PFN_WMCreateReader)( IUnknown* pUnkCert, DWORD dwRights, IWMReader **ppReader );
typedef HRESULT (STDMETHODCALLTYPE *PFN_WMCreateSyncReader)( IUnknown* pUnkCert, DWORD dwRights, IWMSyncReader **ppSyncReader );
typedef HRESULT (STDMETHODCALLTYPE *PFN_WMCreateEditor)( IWMMetadataEditor **ppEditor );
typedef HRESULT (STDMETHODCALLTYPE *PFN_WMCreateIndexer)( IWMIndexer **ppIndexer );
typedef HRESULT (STDMETHODCALLTYPE *PFN_WMCreateBackupRestorer)( IUnknown *pCallback, IWMLicenseBackup **ppBackup );
typedef HRESULT (STDMETHODCALLTYPE *PFN_WMCreateProfileManager)( IWMProfileManager **ppProfileManager );
typedef HRESULT (STDMETHODCALLTYPE *PFN_WMCreateWriterFileSink)( IWMWriterFileSink **ppSink );
typedef HRESULT (STDMETHODCALLTYPE *PFN_WMCreateWriterNetworkSink)( IWMWriterNetworkSink **ppSink );
typedef HRESULT (STDMETHODCALLTYPE *PFN_WMCreateWriterPushSink)( IWMWriterPushSink **ppSink );
    
#define IMPLEMENT_THUNK(func)                                   \
    static PFN_##func p = NULL;                                 \
    if (p == NULL)                                              \
        if (HMODULE hLib = LoadLibrary("WMVCORE"))              \
            p = (PFN_##func)GetProcAddress( hLib, #func );      \
    return p
    
HRESULT STDMETHODCALLTYPE WMIsContentProtected( const WCHAR *pwszFileName, BOOL *pfIsProtected )
{ IMPLEMENT_THUNK(WMIsContentProtected)(pwszFileName, pfIsProtected); }
    
HRESULT STDMETHODCALLTYPE WMCreateCertificate( IUnknown** pUnkCert )
{ IMPLEMENT_THUNK(WMCreateCertificate)(pUnkCert); }

HRESULT STDMETHODCALLTYPE WMCreateWriter( IUnknown* pUnkCert, IWMWriter **ppWriter )
{ IMPLEMENT_THUNK(WMCreateWriter)(pUnkCert, ppWriter); }

HRESULT STDMETHODCALLTYPE WMCreateReader( IUnknown* pUnkCert, DWORD dwRights, IWMReader **ppReader )
{ IMPLEMENT_THUNK(WMCreateReader)(pUnkCert, dwRights, ppReader); }

HRESULT STDMETHODCALLTYPE WMCreateSyncReader( IUnknown* pUnkCert, DWORD dwRights, IWMSyncReader **ppSyncReader )
{ IMPLEMENT_THUNK(WMCreateSyncReader)(pUnkCert, dwRights, ppSyncReader); }

HRESULT STDMETHODCALLTYPE WMCreateEditor( IWMMetadataEditor **ppEditor )
{ IMPLEMENT_THUNK(WMCreateEditor)(ppEditor); }

HRESULT STDMETHODCALLTYPE WMCreateIndexer( IWMIndexer **ppIndexer )
{ IMPLEMENT_THUNK(WMCreateIndexer)(ppIndexer); }

HRESULT STDMETHODCALLTYPE WMCreateBackupRestorer( IUnknown *pCallback, IWMLicenseBackup **ppBackup )
{ IMPLEMENT_THUNK(WMCreateBackupRestorer)(pCallback, ppBackup); }

HRESULT STDMETHODCALLTYPE WMCreateProfileManager( IWMProfileManager **ppProfileManager )
{ IMPLEMENT_THUNK(WMCreateProfileManager)(ppProfileManager); }

HRESULT STDMETHODCALLTYPE WMCreateWriterFileSink( IWMWriterFileSink **ppSink )
{ IMPLEMENT_THUNK(WMCreateWriterFileSink)(ppSink); }

HRESULT STDMETHODCALLTYPE WMCreateWriterNetworkSink( IWMWriterNetworkSink **ppSink )
{ IMPLEMENT_THUNK(WMCreateWriterNetworkSink)(ppSink); }

HRESULT STDMETHODCALLTYPE WMCreateWriterPushSink( IWMWriterPushSink **ppSink )
{ IMPLEMENT_THUNK(WMCreateWriterPushSink)(ppSink); }
